/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.echarts;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.CheckForNull;

public class JacksonFacade {
    private final ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public String toJson(Object bean) {
        try {
            return this.mapper.writeValueAsString(bean);
        }
        catch (JsonProcessingException exception) {
            throw new IllegalArgumentException(String.format("Can't convert %s to JSON object", bean), exception);
        }
    }

    public <T> T fromJson(String json, Class<T> type) {
        try {
            return (T)this.mapper.readValue(json, type);
        }
        catch (JsonProcessingException exception) {
            throw new IllegalArgumentException(String.format("Can't convert JSON '%s' to bean", json), exception);
        }
    }

    public String getString(String json, String property, String defaultValue) {
        try {
            JsonNode typeNode = this.getPropertyAsNode(json, property);
            if (typeNode != null) {
                return typeNode.asText(defaultValue);
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        return defaultValue;
    }

    public int getInteger(String json, String property, int defaultValue) {
        try {
            JsonNode typeNode = this.getPropertyAsNode(json, property);
            if (typeNode != null) {
                return typeNode.asInt(defaultValue);
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        return defaultValue;
    }

    @CheckForNull
    private JsonNode getPropertyAsNode(String json, String property) throws JsonProcessingException {
        ObjectNode node = (ObjectNode)this.mapper.readValue(json, ObjectNode.class);
        return node.get(property);
    }

    public boolean getBoolean(String json, String property, boolean defaultValue) {
        try {
            JsonNode typeNode = this.getPropertyAsNode(json, property);
            if (typeNode != null) {
                return typeNode.asBoolean(defaultValue);
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        return defaultValue;
    }
}

