/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.echarts;

import edu.hm.hafner.echarts.Build;
import edu.hm.hafner.echarts.BuildResult;
import hudson.model.Run;
import io.jenkins.plugins.util.BuildAction;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public class BuildActionIterator<T extends BuildAction<?>>
implements Iterator<BuildResult<T>> {
    private Optional<T> latestAction;
    private final Function<Run<?, ?>, Optional<T>> actionSelector;

    public BuildActionIterator(Class<T> actionType, Optional<T> baseline) {
        this(actionType, baseline, a -> true);
    }

    public BuildActionIterator(Class<T> actionType, Optional<T> baseline, Predicate<? super T> filter) {
        this.latestAction = baseline;
        this.actionSelector = new ActionSelector<T>(actionType, filter);
    }

    @Override
    public boolean hasNext() {
        return this.latestAction.isPresent();
    }

    @Override
    public BuildResult<T> next() {
        if (!this.latestAction.isPresent()) {
            throw new NoSuchElementException("There is no action available anymore. Use hasNext() before calling next().");
        }
        BuildAction buildAction = (BuildAction)this.latestAction.get();
        Run run = buildAction.getOwner();
        this.latestAction = this.actionSelector.apply(run.getPreviousBuild());
        int buildTimeInSeconds = (int)(run.getTimeInMillis() / 1000L);
        Build build = new Build(run.getNumber(), run.getDisplayName(), buildTimeInSeconds);
        return new BuildResult<BuildAction>(build, buildAction);
    }

    private static class ActionSelector<T extends BuildAction<?>>
    implements Function<Run<?, ?>, Optional<T>> {
        private final Class<T> actionType;
        private final Predicate<? super T> predicate;

        ActionSelector(Class<T> actionType, Predicate<? super T> predicate) {
            this.actionType = actionType;
            this.predicate = predicate;
        }

        @Override
        public Optional<T> apply(Run<?, ?> baseline) {
            for (Run run = baseline; run != null; run = run.getPreviousBuild()) {
                Optional<T> action = run.getActions(this.actionType).stream().filter(this.predicate).findAny();
                if (!action.isPresent()) continue;
                return action;
            }
            return Optional.empty();
        }
    }
}

