/*
 * Decompiled with CFR 0.152.
 */
package com.bluersw.analyze;

import com.bluersw.analyze.Configuration;
import com.bluersw.analyze.EmptyFormat;
import com.bluersw.analyze.Format;
import com.bluersw.analyze.JsonFormat;
import com.bluersw.analyze.YamlFormat;
import java.io.InputStream;

public class ConfigurationFactory {
    public static Configuration createConfiguration(Format format, String content) throws Exception {
        if (format == Format.YAML) {
            return new YamlFormat(content);
        }
        if (format == Format.JSON) {
            return new JsonFormat(content);
        }
        if (format == Format.Empty) {
            return new EmptyFormat(content);
        }
        throw new IllegalArgumentException(String.format("There is no implementation of this document format. format\uff1a%s", new Object[]{format}));
    }

    public static Configuration createConfiguration(Format format, InputStream inputStream) throws Exception {
        if (format == Format.YAML) {
            return new YamlFormat(inputStream);
        }
        if (format == Format.JSON) {
            return new JsonFormat(inputStream);
        }
        if (format == Format.Empty) {
            return new EmptyFormat(inputStream);
        }
        throw new IllegalArgumentException(String.format("There is no implementation of this document format. format\uff1a%s", new Object[]{format}));
    }
}

