/*
 * Decompiled with CFR 0.152.
 */
package com.bluersw;

import com.bluersw.CheckboxParameterValue;
import com.bluersw.Messages;
import com.bluersw.analyze.Configuration;
import com.bluersw.analyze.ConfigurationFactory;
import com.bluersw.analyze.Format;
import com.bluersw.model.CheckboxList;
import com.bluersw.model.Result;
import com.bluersw.source.DataSource;
import com.bluersw.source.DataSourceFactory;
import com.bluersw.source.Protocol;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersDefinitionProperty;
import hudson.util.FormValidation;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class CheckboxParameterDefinition
extends ParameterDefinition
implements Comparable<CheckboxParameterDefinition> {
    private static final long serialVersionUID = 5171255336407195201L;
    private static final Logger LOGGER = Logger.getLogger(CheckboxParameterDefinition.class.getName());
    private static final String DEFAULT_NAME_NODE = "//CheckboxParameter/key";
    private static final String DEFAULT_VALUE_NODE = "//CheckboxParameter/value";
    private final UUID uuid = UUID.randomUUID();
    private String defaultValue;
    private Protocol protocol;
    private Format format;
    private String submitContent;
    private String uri;
    private String displayNodePath;
    private String valueNodePath;
    private boolean useInput;

    @DataBoundConstructor
    public CheckboxParameterDefinition(String name, String description, Protocol protocol, Format format, String uri, String displayNodePath, String valueNodePath, JSONObject useInput, String pipelineSubmitContent) {
        super(name, description);
        this.protocol = protocol == null ? Protocol.HTTP_HTTPS : protocol;
        this.format = format == null ? Format.Empty : format;
        this.uri = StringUtils.isNotBlank((String)uri) ? uri : "";
        this.displayNodePath = StringUtils.isNotBlank((String)displayNodePath) ? displayNodePath : DEFAULT_NAME_NODE;
        this.valueNodePath = StringUtils.isNotBlank((String)valueNodePath) ? valueNodePath : DEFAULT_VALUE_NODE;
        this.submitContent = "";
        this.useInput = false;
        this.defaultValue = "";
        if (StringUtils.isNotBlank((String)pipelineSubmitContent)) {
            this.setPipelineSubmitContent(pipelineSubmitContent);
        } else {
            this.setUseInputAndSubmitContent(useInput);
        }
    }

    private void setPipelineSubmitContent(String submitContent) {
        if (StringUtils.isNotBlank((String)submitContent)) {
            this.submitContent = submitContent;
            this.useInput = true;
        }
    }

    private void setUseInputAndSubmitContent(JSONObject jsonObject) {
        if (jsonObject != null) {
            String submitContentName = "submitContent";
            if (jsonObject.get("submitContent") != null) {
                this.submitContent = jsonObject.size() == 0 ? "" : jsonObject.getString("submitContent");
                this.useInput = StringUtils.isNotBlank((String)this.submitContent);
            }
        }
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean getUseInput() {
        return this.useInput;
    }

    @DataBoundSetter
    public void setUseInput(boolean useInput) {
        this.useInput = useInput;
    }

    public String getDisplayNodePath() {
        return this.displayNodePath;
    }

    @DataBoundSetter
    public void setDisplayNodePath(String displayNodePath) {
        this.displayNodePath = displayNodePath;
    }

    public String getValueNodePath() {
        return this.valueNodePath;
    }

    @DataBoundSetter
    public void setValueNodePath(String valueNodePath) {
        this.valueNodePath = valueNodePath;
    }

    public String getUri() {
        return this.uri;
    }

    @DataBoundSetter
    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getSubmitContent() {
        return this.submitContent;
    }

    @DataBoundSetter
    public void setSubmitContent(String submitContent) {
        this.submitContent = submitContent;
    }

    public Format getFormat() {
        return this.format;
    }

    @DataBoundSetter
    public void setFormat(Format format) {
        this.format = format;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    @DataBoundSetter
    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    @CheckForNull
    public ParameterValue createValue(StaplerRequest staplerRequest, JSONObject jsonObject) {
        StringBuilder result = new StringBuilder();
        for (Object o : jsonObject.entrySet()) {
            Map.Entry entry = (Map.Entry)o;
            if (!entry.getKey().toString().startsWith("checkbox_") || !Boolean.parseBoolean(entry.getValue().toString())) continue;
            result.append(CheckboxParameterDefinition.decodeBase64(entry.getKey().toString().replace("checkbox_", "")));
            result.append(',');
        }
        this.defaultValue = result.toString().length() > 0 ? result.toString().substring(0, result.toString().length() - 1) : "";
        return new CheckboxParameterValue(jsonObject.getString("name"), this.defaultValue);
    }

    @CheckForNull
    public ParameterValue createValue(StaplerRequest staplerRequest) {
        String[] value = staplerRequest.getParameterValues(this.getName());
        if (value == null || value.length == 0 || StringUtils.isBlank((String)value[0])) {
            return this.getDefaultParameterValue();
        }
        return new CheckboxParameterValue(this.getName(), value[0]);
    }

    public ParameterValue createValue(CLICommand command, String value) {
        if (StringUtils.isNotEmpty((String)value)) {
            return new CheckboxParameterValue(this.getName(), value);
        }
        return this.getDefaultParameterValue();
    }

    public ParameterValue getDefaultParameterValue() {
        return new CheckboxParameterValue(this.getName(), this.getDefaultValue());
    }

    @Override
    @SuppressFBWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"})
    public int compareTo(CheckboxParameterDefinition o) {
        if (o.uuid.equals(this.uuid)) {
            return 0;
        }
        return -1;
    }

    public String getDivId() {
        return String.format("%s-%s", this.getName().replaceAll("\\W", "_"), this.uuid);
    }

    private Result<String> getFileContent() {
        Result<String> result = new Result<String>();
        if (this.useInput) {
            result.setContent(this.submitContent);
            result.setSucceed(true);
        } else {
            try {
                DataSource source = DataSourceFactory.createDataSource(this.protocol, this.uri);
                result.setContent(source.get());
                result.setSucceed(true);
                if (source.getStatusCode() != 200) {
                    result.setMessage(source.getStatusLine());
                    result.setContent("");
                    result.setSucceed(false);
                }
            }
            catch (Exception e) {
                String exMessage = e.getMessage() == null ? e.toString() : e.getMessage();
                result.setContent("");
                result.setSucceed(false);
                result.setMessage(String.format("%s: %s", Messages.CheckboxParameterDefinition_GetFileFailed(), exMessage));
                LOGGER.log(Level.SEVERE, String.format("Failed to get file content: protocol: %s,uri: %s,exception info: %s", new Object[]{this.protocol, this.uri, exMessage}));
            }
        }
        return result;
    }

    private boolean isExist(String[] array, String value) {
        for (String item : array) {
            if (!item.equals(value)) continue;
            return true;
        }
        return false;
    }

    public CheckboxList getCheckboxList() {
        CheckboxList checkboxList = new CheckboxList();
        Result<String> fileContent = this.getFileContent();
        try {
            if (!fileContent.isSucceed()) {
                checkboxList.message = fileContent.getMessage();
            } else {
                Configuration config = ConfigurationFactory.createConfiguration(this.format, fileContent.getContent());
                List<String> names = config.getValueListBySearch(this.displayNodePath);
                List<String> values = config.getValueListBySearch(this.valueNodePath);
                String[] defaultValues = this.defaultValue.split(",");
                int count = Math.min(names.size(), values.size());
                for (int i = 0; i < count; ++i) {
                    boolean selected = this.isExist(defaultValues, values.get(i));
                    checkboxList.add(names.get(i), CheckboxParameterDefinition.encodeBase64(values.get(i)), selected);
                }
            }
        }
        catch (Exception e) {
            String exMessage = e.getMessage() == null ? e.toString() : e.getMessage();
            checkboxList.message = String.format("%s: %s", Messages.CheckboxParameterDefinition_CreateCheckboxFailed(), exMessage);
            LOGGER.log(Level.SEVERE, String.format("Failed to create checkbox list,exception info: %s", exMessage));
        }
        return checkboxList;
    }

    private static String encodeBase64(String origin) {
        Base64.Encoder encoder = Base64.getEncoder();
        byte[] originBytes = origin.getBytes(StandardCharsets.UTF_8);
        return encoder.encodeToString(originBytes);
    }

    private static String decodeBase64(String origin) {
        Base64.Decoder decoder = Base64.getDecoder();
        try {
            return new String(decoder.decode(origin), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            String exMessage = e.getMessage() == null ? e.toString() : e.getMessage();
            LOGGER.log(Level.SEVERE, String.format("Failed to DecodeBase64,exception info: %s", exMessage));
            return origin;
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Symbol(value={"checkboxParameter"})
    @Extension
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckName(@QueryParameter String name) {
            if (StringUtils.isBlank((String)name)) {
                return FormValidation.error((String)Messages.CheckboxParameterDefinition_Name_IsBlank());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckDisplayNodePath(@QueryParameter String displayNodePath) {
            if (StringUtils.isBlank((String)displayNodePath)) {
                return FormValidation.error((String)Messages.CheckboxParameterDefinition_DisplayNodePath_IsBlank());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckValueNodePath(@QueryParameter String valueNodePath) {
            if (StringUtils.isBlank((String)valueNodePath)) {
                return FormValidation.error((String)Messages.CheckboxParameterDefinition_ValueNodePath_IsBlank());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckTlsVersion(@QueryParameter String tlsVersion) {
            if (StringUtils.isBlank((String)tlsVersion)) {
                return FormValidation.error((String)Messages.CheckboxParameterDefinition_TlsVersion_IsBlank());
            }
            return FormValidation.ok();
        }

        @NonNull
        public String getDisplayName() {
            return Messages.CheckboxParameterDefinition_DescriptorImpl_DisplayName();
        }

        public ParameterDefinition newInstance(@Nullable StaplerRequest req, @NonNull JSONObject formData) {
            assert (req != null);
            return (ParameterDefinition)req.bindJSON(CheckboxParameterDefinition.class, formData);
        }

        public CheckboxList doFillCheckboxItems(@AncestorInPath Job job, @QueryParameter String name) {
            ParameterDefinition pd;
            CheckboxList checkboxList = null;
            ParametersDefinitionProperty prop = (ParametersDefinitionProperty)job.getProperty(ParametersDefinitionProperty.class);
            if (prop != null && (pd = prop.getParameterDefinition(name)) instanceof CheckboxParameterDefinition) {
                CheckboxParameterDefinition cpd = (CheckboxParameterDefinition)pd;
                checkboxList = cpd.getCheckboxList();
            }
            if (checkboxList == null) {
                checkboxList = new CheckboxList();
                checkboxList.message = "Parameter Definition Not Found.";
            }
            return checkboxList;
        }
    }
}

