/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.threshold;

import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.model.Describable;
import hudson.model.Descriptor;
import io.jenkins.plugins.coverage.targets.CoverageElement;
import io.jenkins.plugins.coverage.targets.CoverageElementRegister;
import java.io.Serializable;
import java.util.Objects;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class Threshold
implements ExtensionPoint,
Describable<Threshold>,
Serializable {
    private final String thresholdTarget;
    private float unstableThreshold = 0.0f;
    private float unhealthyThreshold = 0.0f;
    private boolean failUnhealthy = false;

    @DataBoundConstructor
    public Threshold(String thresholdTarget) {
        this.thresholdTarget = thresholdTarget;
    }

    public String getThresholdTarget() {
        return this.thresholdTarget;
    }

    public CoverageElement getThresholdTargetElement() {
        return CoverageElement.get(this.getThresholdTarget());
    }

    public float getUnstableThreshold() {
        return this.unstableThreshold;
    }

    @DataBoundSetter
    public void setUnstableThreshold(float unstableThreshold) {
        this.unstableThreshold = unstableThreshold;
    }

    public float getUnhealthyThreshold() {
        return this.unhealthyThreshold;
    }

    @DataBoundSetter
    public void setUnhealthyThreshold(float unhealthyThreshold) {
        this.unhealthyThreshold = unhealthyThreshold;
    }

    public boolean isFailUnhealthy() {
        return this.failUnhealthy;
    }

    @DataBoundSetter
    public void setFailUnhealthy(boolean failUnhealthy) {
        this.failUnhealthy = failUnhealthy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Threshold threshold = (Threshold)o;
        return Objects.equals(this.getThresholdTarget(), threshold.getThresholdTarget());
    }

    public int hashCode() {
        return Objects.hash(this.getThresholdTarget());
    }

    public String toString() {
        return this.thresholdTarget + " {unstableThreshold=" + this.unstableThreshold + ", unhealthyThreshold=" + this.unhealthyThreshold + "}";
    }

    public Descriptor<Threshold> getDescriptor() {
        return Jenkins.getInstance().getDescriptorOrDie(this.getClass());
    }

    @Extension
    public static final class ThreshHoldDescriptor<T extends Threshold>
    extends Descriptor<Threshold> {
        public ThreshHoldDescriptor() {
            super(Threshold.class);
        }

        public CoverageElement[] getAllCoverageMetrics() {
            return CoverageElementRegister.all();
        }

        public CoverageElement[] getCoverageMetricsByType(String coverageElementType) {
            if (StringUtils.isEmpty((String)coverageElementType)) {
                return this.getAllCoverageMetrics();
            }
            return CoverageElementRegister.listCommonsAndSpecificType(coverageElementType);
        }
    }
}

