/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.targets;

import java.io.Serializable;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public final class Ratio
implements Serializable {
    public final float numerator;
    public final float denominator;
    static NumberFormat dataFormat = new DecimalFormat("000.00");
    static NumberFormat roundDownDataFormat = new DecimalFormat("000.000");
    private static final long serialVersionUID = 1L;
    private static final Ratio[] COMMON_INSTANCES;

    private Ratio(float numerator, float denominator) {
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public String toString() {
        return this.print(this.numerator) + "/" + this.print(this.denominator);
    }

    private String print(float f) {
        int i = (int)f;
        if ((float)i == f) {
            return String.valueOf(i);
        }
        return String.valueOf(f);
    }

    public int getPercentage() {
        float floatPercentage = this.getPercentageFloat();
        int intPercentage = Math.round(floatPercentage);
        if (intPercentage == 100 && (int)floatPercentage < 100) {
            return (int)floatPercentage;
        }
        return intPercentage;
    }

    public float getPercentageFloat() {
        return this.denominator == 0.0f ? (this.numerator == 0.0f ? 100.0f : 0.0f) : 100.0f * this.numerator / this.denominator;
    }

    public String getPercentageString() {
        float floatPercentage = this.getPercentageFloat();
        if (Float.compare(floatPercentage, 99.995f) >= 0) {
            return roundDownDataFormat.format(floatPercentage);
        }
        return dataFormat.format(floatPercentage);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ratio ratio = (Ratio)o;
        return Float.compare(ratio.denominator, this.denominator) == 0 && Float.compare(ratio.numerator, this.numerator) == 0;
    }

    public int hashCode() {
        int result = this.numerator != 0.0f ? Float.floatToIntBits(this.numerator) : 0;
        result = (float)(31 * result) + this.denominator != 0.0f ? Float.floatToIntBits(this.denominator) : 0;
        return result;
    }

    public static Ratio create(float x, float y) {
        return new Ratio(x, y);
    }

    static {
        roundDownDataFormat.setRoundingMode(RoundingMode.DOWN);
        COMMON_INSTANCES = new Ratio[256];
    }
}

