/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.adapter;

import com.google.common.collect.Lists;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.coverage.CoveragePublisher;
import io.jenkins.plugins.coverage.adapter.CoverageAdapter;
import io.jenkins.plugins.coverage.exception.CoverageException;
import io.jenkins.plugins.coverage.source.DefaultSourceFileResolver;
import io.jenkins.plugins.coverage.targets.CoverageResult;
import io.jenkins.plugins.coverage.threshold.Threshold;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.CheckForNull;
import org.kohsuke.stapler.DataBoundSetter;
import org.w3c.dom.Document;

public abstract class CoverageReportAdapter
extends CoverageAdapter {
    private final String path;
    private boolean mergeToOneReport = false;
    private List<Threshold> thresholds = new LinkedList<Threshold>();

    public CoverageReportAdapter(String path) {
        this.path = path;
    }

    @DataBoundSetter
    public void setMergeToOneReport(boolean mergeToOneReport) {
        this.mergeToOneReport = mergeToOneReport;
    }

    public boolean isMergeToOneReport() {
        return this.mergeToOneReport;
    }

    public CoverageResult getResult(File report) throws CoverageException {
        Document document = this.convert(report);
        return this.parseToResult(document, report.getName());
    }

    protected abstract Document convert(File var1) throws CoverageException;

    @CheckForNull
    protected abstract CoverageResult parseToResult(Document var1, String var2) throws CoverageException;

    public List<Threshold> getThresholds() {
        return this.thresholds;
    }

    @DataBoundSetter
    public void setThresholds(List<Threshold> thresholds) {
        this.thresholds = thresholds;
    }

    public String getPath() {
        return this.path;
    }

    public final void performCoveragePlugin(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        this.performCoveragePlugin(run, workspace, launcher, listener, null);
    }

    public final void performCoveragePlugin(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener, DefaultSourceFileResolver sourceFileResolver) throws IOException, InterruptedException {
        CoveragePublisher publisher = new CoveragePublisher();
        publisher.setAdapters(Lists.newArrayList((Object[])new CoverageAdapter[]{this}));
        publisher.setSourceFileResolver(sourceFileResolver);
        publisher.perform(run, workspace, launcher, listener);
    }
}

