/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage;

import hudson.model.Actionable;
import hudson.model.Job;
import hudson.model.ProminentProjectAction;
import hudson.model.Result;
import hudson.model.Run;
import io.jenkins.plugins.coverage.BuildUtils;
import io.jenkins.plugins.coverage.CoverageAction;
import io.jenkins.plugins.coverage.Messages;
import java.io.IOException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class CoverageProjectAction
extends Actionable
implements ProminentProjectAction {
    private transient Run<?, ?> run;

    public CoverageProjectAction(Run<?, ?> run) {
        this.run = run;
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getDisplayName() {
        return Messages.CoverageProjectAction_displayName();
    }

    public String getUrlName() {
        return "coverage";
    }

    public CoverageAction getLastResult() {
        Run<?, ?> b = this.run.getParent().getLastSuccessfulBuild();
        while (b != null) {
            CoverageAction r;
            if ((b.getResult() == Result.SUCCESS || b.getResult() == Result.UNSTABLE) && (r = (CoverageAction)b.getAction(CoverageAction.class)) != null) {
                return r;
            }
            b = BuildUtils.getPreviousNotFailedCompletedBuild(b);
        }
        return null;
    }

    public Integer getLastResultBuild() {
        Run<?, ?> b = this.run.getParent().getLastSuccessfulBuild();
        while (b != null) {
            CoverageAction r;
            if ((b.getResult() == Result.SUCCESS || b.getResult() == Result.UNSTABLE) && (r = (CoverageAction)b.getAction(CoverageAction.class)) != null) {
                return b.getNumber();
            }
            b = BuildUtils.getPreviousNotFailedCompletedBuild(b);
        }
        return null;
    }

    public void doIndex(StaplerRequest req, StaplerResponse rsp) throws IOException {
        Integer buildNumber = this.getLastResultBuild();
        if (buildNumber == null) {
            rsp.sendRedirect2("nodata");
        } else {
            rsp.sendRedirect2("../" + buildNumber + "/coverage");
        }
    }

    public Job<?, ?> getProject() {
        return this.run.getParent();
    }

    public String getSearchUrl() {
        return this.getUrlName();
    }
}

