/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage;

import com.google.common.collect.Sets;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.HealthReport;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.util.RunList;
import io.jenkins.plugins.coverage.CompatibleObjectInputStream;
import io.jenkins.plugins.coverage.CoverageAction;
import io.jenkins.plugins.coverage.Messages;
import io.jenkins.plugins.coverage.adapter.CoverageReportAdapter;
import io.jenkins.plugins.coverage.adapter.CoverageReportAdapterDescriptor;
import io.jenkins.plugins.coverage.detector.Detectable;
import io.jenkins.plugins.coverage.detector.ReportDetector;
import io.jenkins.plugins.coverage.exception.CoverageException;
import io.jenkins.plugins.coverage.source.SourceFileResolver;
import io.jenkins.plugins.coverage.targets.CoverageElement;
import io.jenkins.plugins.coverage.targets.CoverageResult;
import io.jenkins.plugins.coverage.targets.Ratio;
import io.jenkins.plugins.coverage.threshold.Threshold;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import jenkins.MasterToSlaveFileCallable;
import jenkins.branch.MultiBranchProject;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMRevisionAction;
import jenkins.scm.api.mixin.ChangeRequestSCMHead;
import jenkins.scm.api.mixin.ChangeRequestSCMRevision;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jvnet.localizer.Localizable;

public class CoverageProcessor {
    private static final String DEFAULT_REPORT_SAVE_NAME = "coverage-report";
    private Run<?, ?> run;
    private FilePath workspace;
    private TaskListener listener;
    private boolean failUnhealthy;
    private boolean failUnstable;
    private boolean failNoReports;
    private boolean applyThresholdRecursively;
    private String globalTag;
    private boolean calculateDiffForChangeRequests;
    private boolean failBuildIfCoverageDecreasedInChangeRequest;
    private SourceFileResolver sourceFileResolver;

    public CoverageProcessor(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull TaskListener listener) {
        this.run = run;
        this.workspace = workspace;
        this.listener = listener;
    }

    public void performCoverageReport(List<CoverageReportAdapter> reportAdapters, List<ReportDetector> reportDetectors, List<Threshold> globalThresholds) throws IOException, InterruptedException, CoverageException {
        Map<CoverageReportAdapter, List<CoverageResult>> results = this.convertToResults(reportAdapters, reportDetectors);
        CoverageResult coverageReport = this.aggregateReports(results);
        if (coverageReport == null) {
            return;
        }
        coverageReport.setOwner(this.run);
        if (this.sourceFileResolver != null) {
            HashSet<String> possiblePaths = new HashSet<String>();
            coverageReport.getChildrenReal().forEach((s, coverageResult) -> {
                Set<String> paths = coverageResult.getAdditionalProperty("source-file-path");
                if (paths != null) {
                    possiblePaths.addAll(paths);
                }
            });
            if (possiblePaths.size() > 0) {
                this.sourceFileResolver.setPossiblePaths(possiblePaths);
            }
            this.sourceFileResolver.resolveSourceFiles(this.run, this.workspace, this.listener, coverageReport.getPaintedSources());
        }
        if (this.calculateDiffForChangeRequests) {
            this.setDiffInCoverageForChangeRequest(coverageReport);
        }
        CoverageAction action = this.convertResultToAction(coverageReport);
        HealthReport healthReport = this.processThresholds(results, globalThresholds, action);
        action.setHealthReport(healthReport);
        if (this.calculateDiffForChangeRequests && this.failBuildIfCoverageDecreasedInChangeRequest) {
            this.failBuildIfChangeRequestDecreasedCoverage(coverageReport);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoverageAction convertResultToAction(CoverageResult coverageReport) throws IOException {
        Class<CoverageProcessor> clazz = CoverageProcessor.class;
        synchronized (CoverageProcessor.class) {
            CoverageAction previousAction = (CoverageAction)this.run.getAction(CoverageAction.class);
            if (previousAction == null) {
                CoverageProcessor.saveCoverageResult(this.run, coverageReport);
                CoverageAction action = new CoverageAction(coverageReport);
                this.run.addAction((Action)action);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return action;
            }
            CoverageResult previousResult = previousAction.getResult();
            Collection<CoverageResult> previousReports = previousResult.getChildrenReal().values();
            for (CoverageResult report : coverageReport.getChildrenReal().values()) {
                if (StringUtils.isEmpty((String)report.getTag())) {
                    report.resetParent(previousResult);
                    continue;
                }
                Optional<CoverageResult> matchedTagReport = previousReports.stream().filter(r -> !StringUtils.isEmpty((String)r.getTag()) && r.getTag().equals(report.getTag())).findAny();
                if (matchedTagReport.isPresent()) {
                    try {
                        matchedTagReport.get().merge(report);
                    }
                    catch (CoverageException e) {
                        e.printStackTrace();
                        report.resetParent(previousResult);
                    }
                    continue;
                }
                report.resetParent(previousResult);
            }
            previousResult.setOwner(this.run);
            CoverageProcessor.saveCoverageResult(this.run, previousResult);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return previousAction;
        }
    }

    private void setDiffInCoverageForChangeRequest(CoverageResult coverageReport) {
        int numberOfBuildsFromTargetBranch = 50;
        Ratio changeRequestLinesCoverage = coverageReport.getCoverage(CoverageElement.LINE);
        if (changeRequestLinesCoverage == null) {
            return;
        }
        Job job = this.run.getParent();
        ItemGroup parent = job.getParent();
        if (!(parent instanceof MultiBranchProject)) {
            return;
        }
        SCMHead currentBuildSCMHead = SCMHead.HeadByItem.findHead((Item)job);
        if (!(currentBuildSCMHead instanceof ChangeRequestSCMHead)) {
            this.listener.getLogger().println("Current build is not change request build, won't calculate coverage diff");
            return;
        }
        SCMRevisionAction scmRevisionAction = (SCMRevisionAction)this.run.getAction(SCMRevisionAction.class);
        if (scmRevisionAction == null) {
            return;
        }
        SCMRevision currentBuildSCMRevision = scmRevisionAction.getRevision();
        if (!(currentBuildSCMRevision instanceof ChangeRequestSCMRevision)) {
            return;
        }
        int targetBranchSCMHash = ((ChangeRequestSCMRevision)currentBuildSCMRevision).getTarget().hashCode();
        SCMHead targetBranchSCMHead = ((ChangeRequestSCMHead)currentBuildSCMHead).getTarget();
        String targetBranchName = targetBranchSCMHead.getName();
        this.listener.getLogger().println(String.format("Calculating coverage change for change request build is enabled, target branch %s", targetBranchName));
        Job targetBranchJob = ((MultiBranchProject)parent).getItemByBranchName(targetBranchName);
        if (targetBranchJob == null) {
            return;
        }
        Run buildToTakeCoverageFrom = null;
        RunList buildsFromTargetBranchJob = targetBranchJob.getBuilds().limit(50);
        for (Run targetBranchBuild : buildsFromTargetBranchJob) {
            SCMRevisionAction targetBranchBuildRevision = (SCMRevisionAction)targetBranchBuild.getAction(SCMRevisionAction.class);
            if (targetBranchBuildRevision == null || targetBranchBuildRevision.getRevision().hashCode() != targetBranchSCMHash) continue;
            buildToTakeCoverageFrom = targetBranchBuild;
            break;
        }
        if (buildToTakeCoverageFrom == null) {
            return;
        }
        CoverageAction targetBranchCoverageAction = (CoverageAction)buildToTakeCoverageFrom.getAction(CoverageAction.class);
        if (targetBranchCoverageAction == null) {
            return;
        }
        CoverageResult targetBranchCoverageResult = targetBranchCoverageAction.getResult();
        if (targetBranchCoverageResult == null) {
            return;
        }
        Ratio targetBranchLinesCoverage = targetBranchCoverageResult.getCoverage(CoverageElement.LINE);
        if (targetBranchLinesCoverage == null) {
            return;
        }
        float percentageDiff = changeRequestLinesCoverage.getPercentageFloat() - targetBranchLinesCoverage.getPercentageFloat();
        coverageReport.setChangeRequestCoverageDiffWithTargetBranch(percentageDiff);
        coverageReport.setLinkToBuildThatWasUsedForComparison(buildToTakeCoverageFrom.getUrl());
    }

    private void failBuildIfChangeRequestDecreasedCoverage(CoverageResult coverageResult) throws CoverageException {
        if (coverageResult.getChangeRequestCoverageDiffWithTargetBranch() < 0.0f) {
            throw new CoverageException("Fail build because this change request decreases code coverage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<CoverageReportAdapter, List<CoverageResult>> convertToResults(List<CoverageReportAdapter> adapters, List<ReportDetector> reportDetectors) throws IOException, InterruptedException, CoverageException {
        PrintStream logger = this.listener.getLogger();
        HashMap<CoverageReportAdapter, HashSet> reports = new HashMap<CoverageReportAdapter, HashSet>();
        HashMap copiedReport = new HashMap();
        if (adapters != null) {
            Object[] r;
            for (CoverageReportAdapter coverageReportAdapter : adapters) {
                String path = coverageReportAdapter.getPath();
                r = (FilePath[])this.workspace.act((FilePath.FileCallable)new FindReportCallable(path, coverageReportAdapter));
                reports.put(coverageReportAdapter, Sets.newHashSet((Object[])r));
            }
            File runRootDir = this.run.getRootDir();
            for (Map.Entry adapterReports : reports.entrySet()) {
                r = (Set)adapterReports.getValue();
                LinkedList copies = new LinkedList();
                for (FilePath filePath2 : r) {
                    File copy = new File(runRootDir, filePath2.getName());
                    int i = 1;
                    while (copy.exists()) {
                        copy = new File(runRootDir, String.format("%s(%d)", filePath2.getName(), i++));
                    }
                    filePath2.copyTo(new FilePath(copy));
                    copies.add(copy);
                }
                copiedReport.put(adapterReports.getKey(), copies);
            }
        }
        int detectCount = 0;
        if (reportDetectors.size() != 0) {
            for (ReportDetector reportDetector : reportDetectors) {
                Map<CoverageReportAdapter, List<File>> detectedReportFiles = reportDetector.getReports(this.run, this.workspace, this.listener, filePath -> {
                    for (Map.Entry entry : reports.entrySet()) {
                        if (!((Set)entry.getValue()).contains(filePath)) continue;
                        return false;
                    }
                    return true;
                });
                detectCount += detectedReportFiles.values().stream().mapToInt(List::size).sum();
                for (Map.Entry entry : detectedReportFiles.entrySet()) {
                    if (copiedReport.containsKey(entry.getKey())) {
                        ((List)copiedReport.get(entry.getKey())).addAll((Collection)entry.getValue());
                        continue;
                    }
                    copiedReport.put(entry.getKey(), (LinkedList<Object>)entry.getValue());
                }
            }
            logger.printf("Auto Detect was ended: Found %d report%n", detectCount);
        }
        reports.clear();
        HashMap<CoverageReportAdapter, List<CoverageResult>> hashMap = new HashMap<CoverageReportAdapter, List<CoverageResult>>();
        for (Map.Entry adapterReports : copiedReport.entrySet()) {
            List list;
            CoverageReportAdapter adapter = (CoverageReportAdapter)adapterReports.getKey();
            CoverageReportAdapterDescriptor coverageReportAdapterDescriptor = (CoverageReportAdapterDescriptor)adapter.getDescriptor();
            for (File foundedFile : (List)adapterReports.getValue()) {
                try {
                    boolean isValidate;
                    if (coverageReportAdapterDescriptor instanceof Detectable) {
                        isValidate = ((Detectable)((Object)coverageReportAdapterDescriptor)).detect(foundedFile);
                    } else {
                        boolean bl = isValidate = Files.size(Paths.get(foundedFile.toURI())) > 0L;
                    }
                    if (!isValidate) continue;
                    hashMap.putIfAbsent(adapter, new LinkedList());
                    CoverageResult result = adapter.getResult(foundedFile);
                    if (!StringUtils.isEmpty((String)this.globalTag)) {
                        result.setTag(this.globalTag);
                    }
                    ((List)hashMap.get(adapter)).add(result);
                }
                catch (CoverageException e) {
                    e.printStackTrace();
                    logger.printf("report %s for %s has met some errors: %s%n", foundedFile.getAbsolutePath(), adapter.getDescriptor().getDisplayName(), e.getMessage());
                }
                finally {
                    FileUtils.deleteQuietly((File)foundedFile);
                }
            }
            if (!adapter.isMergeToOneReport() || (list = (List)hashMap.get(adapter)) == null || list.size() <= 1) continue;
            CoverageResult report = this.aggregateToOneReport(adapter, list);
            list.clear();
            list.add(report);
        }
        if (hashMap.size() == 0) {
            logger.println("No reports were found");
            if (this.getFailNoReports()) {
                throw new CoverageException("Publish Coverage Failed : No Reports were found");
            }
        } else {
            logger.printf("A total of %d reports were found%n", hashMap.values().stream().mapToLong(Collection::size).sum());
        }
        return hashMap;
    }

    private HealthReport processThresholds(Map<CoverageReportAdapter, List<CoverageResult>> adapterWithResults, List<Threshold> globalThresholds, CoverageAction action) throws CoverageException {
        int healthyCount = 0;
        int unhealthyCount = 0;
        int unstableCount = 0;
        HashSet<Threshold> unstableThresholds = new HashSet<Threshold>();
        Set<Object> unhealthyThresholds = new HashSet();
        LinkedList<CoverageResult> resultTask = new LinkedList<CoverageResult>();
        for (Map.Entry<CoverageReportAdapter, List<CoverageResult>> results : adapterWithResults.entrySet()) {
            List<Threshold> thresholds = results.getKey().getThresholds();
            if (thresholds != null) {
                thresholds = new ArrayList<Threshold>(thresholds);
                for (Threshold t : globalThresholds) {
                    if (thresholds.contains(t)) continue;
                    thresholds.add(t);
                }
            } else {
                thresholds = globalThresholds;
            }
            for (CoverageResult coverageResult : results.getValue()) {
                resultTask.push(coverageResult);
                while (!resultTask.isEmpty()) {
                    CoverageResult r = (CoverageResult)resultTask.pollFirst();
                    assert (r != null);
                    if (this.isApplyThresholdRecursively()) {
                        resultTask.addAll(r.getChildrenReal().values());
                    }
                    for (Threshold threshold : thresholds) {
                        Ratio ratio = r.getCoverage(threshold.getThresholdTargetElement());
                        if (ratio == null) continue;
                        float percentage = ratio.getPercentageFloat();
                        if (percentage < threshold.getUnstableThreshold()) {
                            ++unstableCount;
                            this.listener.getLogger().printf("Code coverage enforcement failed: %s coverage in %s level '%s' is lower than %.2f stable threshold%n", threshold.getThresholdTarget(), r.getElement().getName(), r.getName(), Float.valueOf(threshold.getUnstableThreshold()));
                            unstableThresholds.add(threshold);
                            continue;
                        }
                        if (percentage < threshold.getUnhealthyThreshold()) {
                            ++unhealthyCount;
                            this.listener.getLogger().printf("Code coverage enforcement failed: %s coverage in %s level '%s' is lower than %.2f healthy threshold%n", threshold.getThresholdTarget(), r.getElement().getName(), r.getName(), Float.valueOf(threshold.getUnhealthyThreshold()));
                            unhealthyThresholds.add(threshold);
                            continue;
                        }
                        ++healthyCount;
                    }
                }
            }
        }
        if (unstableCount > 0) {
            if (this.getFailUnstable()) {
                action.setFailMessage(String.format("Build failed because following metrics did not meet stability target: %s.", ((Object)unstableThresholds).toString()));
                throw new CoverageException(action.getFailMessage());
            }
            this.run.setResult(Result.UNSTABLE);
        }
        if (unhealthyCount > 0) {
            if (this.getFailUnhealthy()) {
                action.setFailMessage(String.format("Build failed because following metrics did not meet health target: %s.", unhealthyThresholds.toString()));
                throw new CoverageException(action.getFailMessage());
            }
            if ((unhealthyThresholds = unhealthyThresholds.stream().filter(Threshold::isFailUnhealthy).collect(Collectors.toSet())).size() > 0) {
                action.setFailMessage(String.format("Build failed because following metrics did not meet health target: %s.", unhealthyThresholds.toString()));
                throw new CoverageException(action.getFailMessage());
            }
        }
        int score = healthyCount == 0 && unhealthyCount == 0 && unstableCount == 0 ? 100 : healthyCount * 100 / (healthyCount + unhealthyCount + unstableCount);
        Localizable localizeDescription = Messages._CoverageProcessor_healthReportDescriptionTemplate(score);
        return new HealthReport(score, localizeDescription);
    }

    private CoverageResult aggregateToOneReport(CoverageReportAdapter adapter, List<CoverageResult> results) {
        CoverageResult report = new CoverageResult(CoverageElement.REPORT, null, adapter.getDescriptor().getDisplayName() + ": " + adapter.getPath());
        results.forEach(r -> {
            if (r.getElement().equals(CoverageElement.REPORT)) {
                try {
                    report.merge((CoverageResult)r);
                }
                catch (CoverageException e) {
                    this.listener.getLogger().printf("Failed to aggregate coverage report %s into one report, reason %s", r.getName(), e.getMessage());
                }
            } else {
                r.resetParent(report);
            }
        });
        return report;
    }

    private CoverageResult aggregateReports(Map<CoverageReportAdapter, List<CoverageResult>> results) {
        if (results.size() == 0) {
            return null;
        }
        CoverageResult report = new CoverageResult(CoverageElement.AGGREGATED_REPORT, null, "All reports");
        for (List<CoverageResult> resultList : results.values()) {
            for (CoverageResult result : resultList) {
                result.addParent(report);
            }
        }
        return report;
    }

    public boolean getFailUnhealthy() {
        return this.failUnhealthy;
    }

    public void setFailUnhealthy(boolean failUnhealthy) {
        this.failUnhealthy = failUnhealthy;
    }

    public boolean getFailUnstable() {
        return this.failUnstable;
    }

    public void setFailUnstable(boolean failUnstable) {
        this.failUnstable = failUnstable;
    }

    public boolean getFailNoReports() {
        return this.failNoReports;
    }

    public void setFailNoReports(boolean failNoReports) {
        this.failNoReports = failNoReports;
    }

    public void setSourceFileResolver(SourceFileResolver sourceFileResolver) {
        this.sourceFileResolver = sourceFileResolver;
    }

    public String getGlobalTag() {
        return this.globalTag;
    }

    public void setGlobalTag(String globalTag) {
        this.globalTag = globalTag;
    }

    public boolean isApplyThresholdRecursively() {
        return this.applyThresholdRecursively;
    }

    public void setApplyThresholdRecursively(boolean applyThresholdRecursively) {
        this.applyThresholdRecursively = applyThresholdRecursively;
    }

    public boolean getCalculateDiffForChangeRequests() {
        return this.calculateDiffForChangeRequests;
    }

    public void setCalculateDiffForChangeRequests(boolean calculateDiffForChangeRequests) {
        this.calculateDiffForChangeRequests = calculateDiffForChangeRequests;
    }

    public boolean isFailBuildIfCoverageDecreasedInChangeRequest() {
        return this.failBuildIfCoverageDecreasedInChangeRequest;
    }

    public void setFailBuildIfCoverageDecreasedInChangeRequest(boolean failBuildIfCoverageDecreasedInChangeRequest) {
        this.failBuildIfCoverageDecreasedInChangeRequest = failBuildIfCoverageDecreasedInChangeRequest;
    }

    public static void saveCoverageResult(Run<?, ?> run, CoverageResult report) throws IOException {
        File reportFile = new File(run.getRootDir(), DEFAULT_REPORT_SAVE_NAME);
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(reportFile));){
            oos.writeObject(report);
        }
    }

    public static CoverageResult recoverCoverageResult(Run<?, ?> run) throws IOException, ClassNotFoundException {
        File reportFile = new File(run.getRootDir(), DEFAULT_REPORT_SAVE_NAME);
        try (CompatibleObjectInputStream ois = new CompatibleObjectInputStream(new FileInputStream(reportFile));){
            CoverageResult coverageResult = (CoverageResult)ois.readObject();
            return coverageResult;
        }
    }

    private static class FindReportCallable
    extends MasterToSlaveFileCallable<FilePath[]> {
        private final String reportFilePath;
        private final CoverageReportAdapter reportAdapter;

        public FindReportCallable(String reportFilePath, CoverageReportAdapter reportAdapter) {
            this.reportFilePath = reportFilePath;
            this.reportAdapter = reportAdapter;
        }

        public FilePath[] invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            FilePath[] r;
            for (FilePath filePath : r = new FilePath(f).list(this.reportFilePath)) {
            }
            return r;
        }
    }
}

