/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage;

import hudson.Extension;
import hudson.model.Job;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import io.jenkins.plugins.coverage.CoverageAction;
import io.jenkins.plugins.coverage.CoverageProjectAction;
import io.jenkins.plugins.coverage.Messages;
import io.jenkins.plugins.coverage.targets.CoverageElement;
import io.jenkins.plugins.coverage.targets.CoverageResult;
import io.jenkins.plugins.coverage.targets.Ratio;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class CoverageColumn
extends ListViewColumn {
    @DataBoundConstructor
    public CoverageColumn() {
    }

    public String getColumnCaption() {
        return Messages.CoverageColumn_Caption();
    }

    public String getUrl(Job<?, ?> project) {
        CoverageAction action = this.getAction(project);
        if (action == null) {
            return null;
        }
        return project.getUrl() + action.getUrlName();
    }

    public CoverageAction getAction(Job<?, ?> project) {
        CoverageProjectAction action = (CoverageProjectAction)project.getAction(CoverageProjectAction.class);
        if (action != null) {
            return action.getLastResult();
        }
        return null;
    }

    public boolean hasUrl(Job<?, ?> project) {
        return this.getAction(project) != null;
    }

    public String getCoverage(Job<?, ?> project) {
        CoverageAction action = this.getAction(project);
        if (action == null || action.getResult() == null) {
            return Messages.CoverageColumn_CoverageEmpty();
        }
        CoverageResult result = action.getResult();
        Ratio coverageRatio = result.getCoverage(CoverageElement.LINE);
        if (coverageRatio == null) {
            return Messages.CoverageColumn_CoverageEmpty();
        }
        String coveragePercentage = coverageRatio.getPercentageString();
        coveragePercentage = StringUtils.stripStart((String)coveragePercentage, (String)"0");
        if ((coveragePercentage = StringUtils.stripEnd((String)coveragePercentage, (String)"0")).equals("0") || coveragePercentage.equals("")) {
            return "0%";
        }
        return coveragePercentage + "%";
    }

    @Extension
    public static class ColumnDescriptor
    extends ListViewColumnDescriptor {
        public boolean shownByDefault() {
            return false;
        }

        public String getDisplayName() {
            return Messages.CoverageColumn_ColumnName();
        }
    }
}

