/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.adapter.parser;

import io.jenkins.plugins.coverage.adapter.parser.CoverageParser;
import io.jenkins.plugins.coverage.targets.CoverageElement;
import io.jenkins.plugins.coverage.targets.CoverageResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Element;

public class JavaCoverageParser
extends CoverageParser {
    private static final Pattern METHOD_SIGNATURE_PATTERN = Pattern.compile("\\((.*)\\)(.*)");
    private static final Pattern METHOD_ARGS_PATTERN = Pattern.compile("\\[*([TL][^;]*;)|([ZCBSIFJDV])");

    public JavaCoverageParser(String reportName) {
        super(reportName);
    }

    @Override
    protected CoverageResult processElement(Element current, CoverageResult parentResult) {
        CoverageResult result = null;
        switch (current.getLocalName()) {
            case "report": {
                result = new CoverageResult(CoverageElement.REPORT, null, this.getAttribute(current, "name", "") + ": " + this.getReportName());
                break;
            }
            case "group": {
                result = new CoverageResult(CoverageElement.get("Group"), parentResult, this.getAttribute(current, "name", "project"));
                break;
            }
            case "package": {
                result = new CoverageResult(CoverageElement.get("Package"), parentResult, this.getAttribute(current, "name", "<default>"));
                break;
            }
            case "file": {
                result = new CoverageResult(CoverageElement.get("File"), parentResult, this.getAttribute(current, "name", ""));
                result.setRelativeSourcePath(this.getAttribute(current, "name", null));
                break;
            }
            case "class": {
                result = new CoverageResult(CoverageElement.get("Class"), parentResult, this.getAttribute(current, "name", ""));
                break;
            }
            case "method": {
                String name = this.getAttribute(current, "name", "");
                String signature = this.getAttribute(current, "signature", "");
                String methodName = this.buildMethodName(name, signature);
                result = new CoverageResult(CoverageElement.get("Method"), parentResult, methodName);
                break;
            }
            case "line": {
                this.processLine(current, parentResult);
                break;
            }
            case "additionalProperty": {
                String propertyName = this.getAttribute(current, "name", "");
                if (StringUtils.isEmpty((String)propertyName)) break;
                String propertyValue = this.getAttribute(current, "value", "");
                parentResult.addAdditionalProperty(propertyName, propertyValue);
                break;
            }
        }
        return result;
    }

    private String buildMethodName(String name, String signature) {
        Matcher signatureMatcher = METHOD_SIGNATURE_PATTERN.matcher(signature);
        StringBuilder methodName = new StringBuilder();
        if (signatureMatcher.matches()) {
            String returnType = signatureMatcher.group(2);
            Matcher matcher = METHOD_ARGS_PATTERN.matcher(returnType);
            if (matcher.matches()) {
                methodName.append(this.parseMethodArg(matcher.group()));
                methodName.append(' ');
            }
            methodName.append(name);
            String args = signatureMatcher.group(1);
            matcher = METHOD_ARGS_PATTERN.matcher(args);
            methodName.append('(');
            boolean first = true;
            while (matcher.find()) {
                if (!first) {
                    methodName.append(',');
                }
                methodName.append(this.parseMethodArg(matcher.group()));
                first = false;
            }
            methodName.append(')');
        } else {
            methodName.append(name);
        }
        return methodName.toString();
    }

    private String parseMethodArg(String s) {
        char c = s.charAt(0);
        switch (c) {
            case 'Z': {
                return "boolean";
            }
            case 'C': {
                return "char";
            }
            case 'B': {
                return "byte";
            }
            case 'S': {
                return "short";
            }
            case 'I': {
                return "int";
            }
            case 'F': {
                return "float";
            }
            case 'J': {
                return "long";
            }
            case 'D': {
                return "double";
            }
            case 'V': {
                return "void";
            }
            case '[': {
                return this.parseMethodArg(s.substring(1)) + "[]";
            }
            case 'L': 
            case 'T': {
                int end = s.indexOf(59);
                return s.substring(1, end).replace('/', '.');
            }
        }
        return s;
    }
}

