/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.adapter;

import hudson.Extension;
import io.jenkins.plugins.coverage.adapter.CoverageReportAdapter;
import io.jenkins.plugins.coverage.adapter.JavaCoverageReportAdapterDescriptor;
import io.jenkins.plugins.coverage.adapter.JavaXMLCoverageReportAdapter;
import io.jenkins.plugins.coverage.adapter.Messages;
import io.jenkins.plugins.coverage.adapter.parser.JavaCoverageParser;
import io.jenkins.plugins.coverage.exception.CoverageException;
import io.jenkins.plugins.coverage.targets.CoverageElement;
import io.jenkins.plugins.coverage.targets.CoverageResult;
import io.jenkins.plugins.coverage.targets.Ratio;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class JacocoReportAdapter
extends JavaXMLCoverageReportAdapter {
    @DataBoundConstructor
    public JacocoReportAdapter(String path) {
        super(path);
    }

    @Override
    public String getXSL() {
        return "jacoco-to-standard.xsl";
    }

    @Override
    public String getXSD() {
        return null;
    }

    @Override
    public CoverageResult parseToResult(Document document, String reportName) throws CoverageException {
        return new JacocoCoverageParser(reportName).parse(document);
    }

    public static final class JacocoCoverageParser
    extends JavaCoverageParser {
        public JacocoCoverageParser(String reportName) {
            super(reportName);
        }

        @Override
        protected CoverageResult processElement(Element current, CoverageResult parentResult) {
            CoverageResult result = super.processElement(current, parentResult);
            if (this.getAttribute(current, "attr-mode", null) != null) {
                int missed;
                int covered;
                String lineCoveredAttr = this.getAttribute(current, "line-covered");
                String lineMissedAttr = this.getAttribute(current, "line-missed");
                String branchCoveredAttr = this.getAttribute(current, "br-covered");
                String branchMissedAttr = this.getAttribute(current, "br-missed");
                String instructionCoveredAttr = this.getAttribute(current, "instruction-covered");
                String instructionMissedAttr = this.getAttribute(current, "instruction-missed");
                if (StringUtils.isNumeric((String)lineCoveredAttr) && StringUtils.isNumeric((String)lineMissedAttr)) {
                    covered = Integer.parseInt(lineCoveredAttr);
                    missed = Integer.parseInt(lineMissedAttr);
                    result.updateCoverage(CoverageElement.LINE, Ratio.create(covered, covered + missed));
                }
                if (StringUtils.isNumeric((String)branchCoveredAttr) && StringUtils.isNumeric((String)branchMissedAttr)) {
                    covered = Integer.parseInt(branchCoveredAttr);
                    missed = Integer.parseInt(branchMissedAttr);
                    result.updateCoverage(CoverageElement.CONDITIONAL, Ratio.create(covered, covered + missed));
                }
                if (StringUtils.isNumeric((String)instructionCoveredAttr) && StringUtils.isNumeric((String)instructionMissedAttr)) {
                    covered = Integer.parseInt(instructionCoveredAttr);
                    missed = Integer.parseInt(instructionMissedAttr);
                    result.updateCoverage(CoverageElement.get("Instruction"), Ratio.create(covered, covered + missed));
                }
            }
            return result;
        }
    }

    @Symbol(value={"jacocoAdapter", "jacoco"})
    @Extension
    public static final class JacocoReportAdapterDescriptor
    extends JavaCoverageReportAdapterDescriptor {
        public JacocoReportAdapterDescriptor() {
            super((Class<? extends CoverageReportAdapter>)JacocoReportAdapter.class);
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.JacocoReportAdapter_displayName();
        }

        @Override
        public List<CoverageElement> getCoverageElements() {
            List<CoverageElement> registerCoverageElements = super.getCoverageElements();
            registerCoverageElements.add(new CoverageElement("Instruction", 5));
            return registerCoverageElements;
        }
    }
}

