/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

public class CompatibleObjectInputStream
extends ObjectInputStream {
    public CompatibleObjectInputStream(InputStream in) throws IOException {
        super(in);
    }

    @Override
    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        ObjectStreamClass resultClassDescriptor = super.readClassDescriptor();
        Class<?> localClass = Class.forName(resultClassDescriptor.getName());
        ObjectStreamClass localClassDescriptor = ObjectStreamClass.lookup(localClass);
        if (localClassDescriptor != null) {
            long localSUID = localClassDescriptor.getSerialVersionUID();
            long streamSUID = resultClassDescriptor.getSerialVersionUID();
            if (streamSUID != localSUID) {
                String s = String.format("Overriding serialized class %s version mismatch: local serialVersionUID = %d stream serialVersionUID = %d", resultClassDescriptor.getName(), localSUID, streamSUID);
                InvalidClassException e = new InvalidClassException(s);
                System.out.println("Potentially Fatal Deserialization Operation. " + e);
                resultClassDescriptor = localClassDescriptor;
            }
        }
        return resultClassDescriptor;
    }
}

