/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.checks.steps;

import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.checks.api.ChecksConclusion;
import io.jenkins.plugins.checks.api.ChecksDetails;
import io.jenkins.plugins.checks.api.ChecksOutput;
import io.jenkins.plugins.checks.api.ChecksPublisherFactory;
import io.jenkins.plugins.checks.api.ChecksStatus;
import io.jenkins.plugins.checks.steps.ChecksInfo;
import io.jenkins.plugins.util.PluginLogger;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.CauseOfInterruption;
import org.jenkinsci.plugins.displayurlapi.DisplayURLProvider;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class WithChecksStep
extends Step
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;

    @DataBoundConstructor
    public WithChecksStep(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public StepExecution start(StepContext stepContext) {
        return new WithChecksStepExecution(stepContext, this);
    }

    static class WithChecksStepExecution
    extends AbstractStepExecutionImpl {
        private static final long serialVersionUID = 1L;
        private static final Logger SYSTEM_LOGGER = Logger.getLogger(WithChecksStepExecution.class.getName());
        private final WithChecksStep step;

        WithChecksStepExecution(StepContext context, WithChecksStep step) {
            super(context);
            this.step = step;
        }

        public boolean start() {
            ChecksInfo info = this.extractChecksInfo();
            this.getContext().newBodyInvoker().withContext((Object)info).withCallback((BodyExecutionCallback)new WithChecksCallBack(info, this)).start();
            return false;
        }

        @VisibleForTesting
        ChecksInfo extractChecksInfo() {
            return new ChecksInfo(this.step.name);
        }

        public void stop(Throwable cause) {
            try {
                this.publish(this.getContext(), new ChecksDetails.ChecksDetailsBuilder().withName(this.step.getName()).withStatus(ChecksStatus.COMPLETED).withConclusion(ChecksConclusion.CANCELED));
            }
            catch (WithChecksPublishException e) {
                cause.addSuppressed(e);
            }
            this.getContext().onFailure(cause);
        }

        private void publish(StepContext context, ChecksDetails.ChecksDetailsBuilder builder) throws WithChecksPublishException {
            Run run;
            TaskListener listener = TaskListener.NULL;
            try {
                listener = (TaskListener)Util.fixNull((Object)((TaskListener)context.get(TaskListener.class)), (Object)TaskListener.NULL);
            }
            catch (IOException | InterruptedException e) {
                SYSTEM_LOGGER.log(Level.WARNING, ("Failed getting TaskListener from the context: " + e).replaceAll("\r\n", ""));
            }
            PluginLogger pluginLogger = new PluginLogger(listener.getLogger(), "Checks API");
            try {
                run = (Run)context.get(Run.class);
            }
            catch (IOException | InterruptedException e) {
                String msg = "Failed getting Run from the context on the start of withChecks step";
                pluginLogger.log((msg + ": " + e).replaceAll("\r\n", ""), new Object[0]);
                SYSTEM_LOGGER.log(Level.WARNING, msg, e);
                throw new WithChecksPublishException(msg, e);
            }
            if (run == null) {
                String msg = "No Run found in the context.";
                pluginLogger.log(msg, new Object[0]);
                SYSTEM_LOGGER.log(Level.WARNING, msg);
                throw new WithChecksPublishException(msg);
            }
            try {
                ChecksPublisherFactory.fromRun(run, listener).publish(builder.withDetailsURL(DisplayURLProvider.get().getRunURL(run)).build());
            }
            catch (RuntimeException e) {
                throw new WithChecksPublishException(e);
            }
        }

        static class WithChecksCallBack
        extends BodyExecutionCallback {
            private static final long serialVersionUID = 1L;
            private final ChecksInfo info;
            private final WithChecksStepExecution execution;

            WithChecksCallBack(ChecksInfo info, WithChecksStepExecution execution) {
                this.info = info;
                this.execution = execution;
            }

            public void onStart(StepContext context) {
                try {
                    this.execution.publish(context, new ChecksDetails.ChecksDetailsBuilder().withName(this.info.getName()).withStatus(ChecksStatus.IN_PROGRESS).withConclusion(ChecksConclusion.NONE));
                }
                catch (WithChecksPublishException e) {
                    context.onFailure((Throwable)e);
                }
            }

            public void onSuccess(StepContext context, Object result) {
                context.onSuccess(result);
            }

            public void onFailure(StepContext context, Throwable t) {
                ChecksDetails.ChecksDetailsBuilder builder = new ChecksDetails.ChecksDetailsBuilder().withName(this.info.getName()).withStatus(ChecksStatus.COMPLETED);
                ChecksOutput.ChecksOutputBuilder outputBuilder = new ChecksOutput.ChecksOutputBuilder().withSummary("occurred while executing withChecks step.");
                if (t instanceof FlowInterruptedException) {
                    FlowInterruptedException fi = (FlowInterruptedException)t;
                    String summary = fi.getCauses().stream().map(CauseOfInterruption::getShortDescription).collect(Collectors.joining("\n\n"));
                    builder.withConclusion(ChecksConclusion.CANCELED).withOutput(outputBuilder.withTitle("Cancelled").withText(summary).build());
                } else {
                    builder.withConclusion(ChecksConclusion.FAILURE).withOutput(outputBuilder.withTitle("Failed").withText(t.toString()).build());
                }
                try {
                    this.execution.publish(context, builder);
                }
                catch (WithChecksPublishException e) {
                    t.addSuppressed(e);
                }
                context.onFailure(t);
            }
        }
    }

    private static class WithChecksPublishException
    extends Exception {
        public static final long serialVersionUID = 1L;

        WithChecksPublishException(Throwable cause) {
            super(cause);
        }

        WithChecksPublishException(String msg) {
            super(msg);
        }

        WithChecksPublishException(String msg, Throwable e) {
            super(msg, e);
        }
    }

    @Extension
    public static class WithChecksStepDescriptor
    extends StepDescriptor {
        public String getFunctionName() {
            return "withChecks";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(Run.class, TaskListener.class)));
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        @NonNull
        public String getDisplayName() {
            return "Inject checks properties into its closure";
        }
    }
}

