/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.checks.api;

import io.jenkins.plugins.checks.api.ChecksAnnotation;
import io.jenkins.plugins.checks.api.ChecksImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ChecksOutput {
    private final String title;
    private final String summary;
    private final String text;
    private final List<ChecksAnnotation> annotations;
    private final List<ChecksImage> images;

    private ChecksOutput(String title, String summary, String text, List<ChecksAnnotation> annotations, List<ChecksImage> images) {
        this.title = title;
        this.summary = summary;
        this.text = text;
        this.annotations = annotations;
        this.images = images;
    }

    public ChecksOutput(ChecksOutput that) {
        this(that.getTitle().orElse(null), that.getSummary().orElse(null), that.getText().orElse(null), that.getChecksAnnotations(), that.getChecksImages());
    }

    public Optional<String> getTitle() {
        return Optional.ofNullable(this.title);
    }

    public Optional<String> getSummary() {
        return Optional.ofNullable(this.summary);
    }

    public Optional<String> getText() {
        return Optional.ofNullable(this.text);
    }

    public List<ChecksAnnotation> getChecksAnnotations() {
        return this.annotations;
    }

    public List<ChecksImage> getChecksImages() {
        return this.images;
    }

    public String toString() {
        return "ChecksOutput{title='" + this.title + '\'' + ", summary='" + this.summary + '\'' + ", text='" + this.text + '\'' + ", annotations=" + this.annotations + ", images=" + this.images + '}';
    }

    public static class ChecksOutputBuilder {
        private String title;
        private String summary;
        private String text;
        private List<ChecksAnnotation> annotations = new ArrayList<ChecksAnnotation>();
        private List<ChecksImage> images = new ArrayList<ChecksImage>();

        public ChecksOutputBuilder withTitle(String title) {
            this.title = Objects.requireNonNull(title);
            return this;
        }

        public ChecksOutputBuilder withSummary(String summary) {
            this.summary = Objects.requireNonNull(summary);
            return this;
        }

        public ChecksOutputBuilder withText(String text) {
            this.text = Objects.requireNonNull(text);
            return this;
        }

        public ChecksOutputBuilder withAnnotations(List<ChecksAnnotation> annotations) {
            this.annotations = new ArrayList<ChecksAnnotation>((Collection)Objects.requireNonNull(annotations));
            return this;
        }

        public ChecksOutputBuilder addAnnotation(ChecksAnnotation annotation) {
            this.annotations.add(new ChecksAnnotation(Objects.requireNonNull(annotation)));
            return this;
        }

        public ChecksOutputBuilder withImages(List<ChecksImage> images) {
            this.images = new ArrayList<ChecksImage>((Collection)Objects.requireNonNull(images));
            return this;
        }

        public ChecksOutputBuilder addImage(ChecksImage image) {
            this.images.add(Objects.requireNonNull(image));
            return this;
        }

        public ChecksOutput build() {
            return new ChecksOutput(this.title, this.summary, this.text, Collections.unmodifiableList(this.annotations), Collections.unmodifiableList(this.images));
        }
    }
}

