/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.chaosmonkey;

import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import jenkins.YesNoMaybe;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class LatencyRule
extends AbstractDescribableImpl<LatencyRule> {
    private String path;
    private Pattern pattern;
    private int latency;
    private double ratio;

    @DataBoundConstructor
    public LatencyRule(String path, int latency, double ratio) {
        this.path = path;
        this.latency = latency;
        this.ratio = ratio;
        this.pattern = Pattern.compile(path);
    }

    public String getPath() {
        return this.path;
    }

    public int getLatency() {
        return this.latency;
    }

    public double getRatio() {
        return this.ratio;
    }

    public void apply(HttpServletRequest request) {
        if (Math.random() < this.ratio && this.pattern.matcher(request.getPathInfo()).matches()) {
            try {
                Thread.sleep(this.latency);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Extension(dynamicLoadable=YesNoMaybe.NO)
    public static final class DescriptorImpl
    extends Descriptor<LatencyRule> {
        @Nonnull
        public String getDisplayName() {
            return "Latency Item";
        }

        public FormValidation doCheckLatency(@QueryParameter String value) {
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.warning((String)"Please specify a latency.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPath(@QueryParameter String path) {
            if (StringUtils.isEmpty((String)path)) {
                return FormValidation.warning((String)"Please specify a path.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckRatio(@QueryParameter String ratio) {
            if (StringUtils.isEmpty((String)ratio)) {
                return FormValidation.warning((String)"Please specify a ratio.");
            }
            return FormValidation.ok();
        }
    }
}

