/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.chaosmonkey;

import com.google.inject.Inject;
import com.google.inject.Injector;
import hudson.Extension;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.util.PluginServletFilter;
import io.jenkins.plugins.chaosmonkey.ChaosMonkeyConfiguration;
import io.jenkins.plugins.chaosmonkey.LatencyRule;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;

@Extension
public class LatencyFilter
implements Filter {
    private static final Logger LOG = Logger.getLogger(LatencyFilter.class.getName());
    @Inject
    private ChaosMonkeyConfiguration configuration;

    @Initializer(after=InitMilestone.PLUGINS_PREPARED)
    public static void init() throws ServletException {
        Injector injector = Jenkins.get().getInjector();
        if (injector == null) {
            return;
        }
        PluginServletFilter.addFilter((Filter)((Filter)injector.getInstance(LatencyFilter.class)));
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            LOG.log(Level.WARNING, "expecting an HttpServletRequest, got: {0}", request.getClass().getName());
            chain.doFilter(request, response);
            return;
        }
        List<LatencyRule> latencies = this.configuration.getLatencies();
        if (latencies != null) {
            latencies.forEach(latencyRule -> latencyRule.apply((HttpServletRequest)request));
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

