/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucketpushandpullrequest.observer;

import io.jenkins.plugins.bitbucketpushandpullrequest.model.BitBucketPPRHookEvent;
import io.jenkins.plugins.bitbucketpushandpullrequest.observer.BitBucketPPRObservable;
import io.jenkins.plugins.bitbucketpushandpullrequest.observer.BitBucketPPRPullRequestCloudObserver;
import io.jenkins.plugins.bitbucketpushandpullrequest.observer.BitBucketPPRPullRequestServerObserver;
import io.jenkins.plugins.bitbucketpushandpullrequest.observer.BitBucketPPRPushCloudObserver;
import io.jenkins.plugins.bitbucketpushandpullrequest.observer.BitBucketPPRPushServerObserver;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public class BitBucketPPRObserverFactory {
    static final Logger logger = Logger.getLogger(BitBucketPPRObserverFactory.class.getName());

    private BitBucketPPRObserverFactory() {
    }

    public static BitBucketPPRObservable createObservable(@Nonnull BitBucketPPRHookEvent bitbucketEvent) {
        BitBucketPPRObservable observable = new BitBucketPPRObservable();
        if ("repo".equalsIgnoreCase(bitbucketEvent.getEvent()) && "push".equalsIgnoreCase(bitbucketEvent.getAction())) {
            logger.log(Level.FINE, "Add BitBucketPPRPushCloudObserver for {}", bitbucketEvent);
            observable.addObserver(new BitBucketPPRPushCloudObserver());
        }
        if ("repo".equalsIgnoreCase(bitbucketEvent.getEvent()) && "refs_changed".equalsIgnoreCase(bitbucketEvent.getAction())) {
            logger.log(Level.FINE, "Add BitBucketPPRPushServerObserver for {}", bitbucketEvent);
            observable.addObserver(new BitBucketPPRPushServerObserver());
        }
        if ("pullrequest".equals(bitbucketEvent.getEvent())) {
            logger.log(Level.FINE, "Add BitBucketPPRPullRequestCloudObserver for {}", bitbucketEvent);
            observable.addObserver(new BitBucketPPRPullRequestCloudObserver());
        }
        if ("pr".equals(bitbucketEvent.getEvent())) {
            logger.log(Level.FINE, "Add BitBucketPPRPullRequestServerObserver for {}", bitbucketEvent);
            observable.addObserver(new BitBucketPPRPullRequestServerObserver());
        }
        if (observable.getObservers().isEmpty()) {
            logger.log(Level.FINE, "No observer found for the observable of event {}", bitbucketEvent);
        }
        return observable;
    }
}

