/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucketpushandpullrequest.observer;

import io.jenkins.plugins.bitbucketpushandpullrequest.event.BitBucketPPREvent;
import io.jenkins.plugins.bitbucketpushandpullrequest.observer.BitBucketPPRObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BitBucketPPRObservable {
    private static final Logger logger = Logger.getLogger(BitBucketPPRObservable.class.getName());
    private List<BitBucketPPRObserver> observers = new ArrayList<BitBucketPPRObserver>();

    public void addObserver(BitBucketPPRObserver observer) {
        this.observers.add(observer);
    }

    public void removeObserver(BitBucketPPRObserver observer) {
        this.observers.remove(observer);
    }

    public void notifyObservers(BitBucketPPREvent event) {
        if (this.observers == null) {
            return;
        }
        for (BitBucketPPRObserver observer : this.observers) {
            if (observer != null && event != null) {
                logger.log(Level.INFO, "Event: {0} for observer {1}", new String[]{event.toString(), observer.toString()});
                observer.getNotification(event);
                continue;
            }
            logger.log(Level.INFO, "observer or event are null");
        }
    }

    public List<BitBucketPPRObserver> getObservers() {
        return this.observers;
    }
}

