/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucketpushandpullrequest.filter.repository;

import hudson.Extension;
import io.jenkins.plugins.bitbucketpushandpullrequest.action.BitBucketPPRAction;
import io.jenkins.plugins.bitbucketpushandpullrequest.cause.BitBucketPPRTriggerCause;
import io.jenkins.plugins.bitbucketpushandpullrequest.cause.repository.BitBucketPPRServerRepositoryCause;
import io.jenkins.plugins.bitbucketpushandpullrequest.filter.repository.BitBucketPPRRepositoryActionDescriptor;
import io.jenkins.plugins.bitbucketpushandpullrequest.filter.repository.BitBucketPPRRepositoryActionFilter;
import io.jenkins.plugins.bitbucketpushandpullrequest.model.BitBucketPPRHookEvent;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class BitBucketPPRServerRepositoryPushActionFilter
extends BitBucketPPRRepositoryActionFilter {
    private static final Logger logger = Logger.getLogger(BitBucketPPRServerRepositoryPushActionFilter.class.getName());
    public boolean triggerAlsoIfTagPush;
    public boolean triggerOnlyIfTagPush;
    public boolean triggerAlsoIfNothingChanged;
    public String allowedBranches;
    public boolean isToApprove;

    @DataBoundConstructor
    public BitBucketPPRServerRepositoryPushActionFilter(boolean triggerAlsoIfTagPush, boolean triggerAlsoIfNothingChanged, String allowedBranches) {
        this.triggerAlsoIfTagPush = triggerAlsoIfTagPush;
        this.triggerAlsoIfNothingChanged = triggerAlsoIfNothingChanged;
        this.allowedBranches = allowedBranches;
    }

    @DataBoundSetter
    public void setTriggerOnlyIfTagPush(boolean triggerOnlyIfTagPush) {
        this.triggerOnlyIfTagPush = triggerOnlyIfTagPush;
    }

    @DataBoundSetter
    public void setIsToApprove(boolean isToApprove) {
        this.isToApprove = isToApprove;
    }

    @Override
    public boolean shouldTriggerBuild(BitBucketPPRAction bitbucketAction) {
        logger.info(() -> "Should trigger build for bitbucket action" + bitbucketAction.toString() + "?");
        if (!(bitbucketAction.getType().equalsIgnoreCase("BRANCH") || bitbucketAction.getType().equalsIgnoreCase("named_branch") || bitbucketAction.getType().equalsIgnoreCase("UPDATE") || bitbucketAction.getType().equalsIgnoreCase("TAG") || this.triggerAlsoIfTagPush)) {
            logger.info(() -> "Neither bitbucketActionType is BRANCH, nor UPDATE, nor trigger on tag push is set for bitbucket type: " + bitbucketAction.getType() + ".");
            return false;
        }
        if (this.triggerOnlyIfTagPush && !bitbucketAction.getType().equalsIgnoreCase("TAG")) {
            return false;
        }
        logger.log(Level.FINEST, "the target branch is: {0}.", bitbucketAction.getTargetBranch());
        logger.log(Level.FINEST, "the target branch ref id is: {0}.", bitbucketAction.getTargetBranchRefId());
        logger.log(Level.FINEST, "The allowed branches are: {0}.", this.allowedBranches);
        return this.matches(this.allowedBranches, bitbucketAction.getTargetBranch(), null) || this.matches(this.allowedBranches, bitbucketAction.getTargetBranchRefId(), null);
    }

    @Override
    public BitBucketPPRTriggerCause getCause(File pollingLog, BitBucketPPRAction bitbucketAction, BitBucketPPRHookEvent bitBucketEvent) throws IOException {
        return new BitBucketPPRServerRepositoryCause(pollingLog, bitbucketAction, bitBucketEvent);
    }

    public String getAllowedBranches() {
        return this.allowedBranches;
    }

    public void setAllowedBranches(String allowedBranches) {
        this.allowedBranches = allowedBranches;
    }

    @Override
    public boolean shouldTriggerAlsoIfNothingChanged() {
        return this.triggerAlsoIfNothingChanged;
    }

    @Override
    public boolean shouldSendApprove() {
        return this.isToApprove;
    }

    @Extension
    public static class ActionFilterDescriptorImpl
    extends BitBucketPPRRepositoryActionDescriptor {
        public String getDisplayName() {
            return "Bitbucket Server Push";
        }
    }
}

