/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucketpushandpullrequest.filter;

import io.jenkins.plugins.bitbucketpushandpullrequest.filter.BitBucketPPRTriggerFilter;
import io.jenkins.plugins.bitbucketpushandpullrequest.filter.pullrequest.cloud.BitBucketPPRPullRequestTriggerFilter;
import io.jenkins.plugins.bitbucketpushandpullrequest.filter.pullrequest.cloud.BitBucketPPRPullRequestTriggerMatcher;
import io.jenkins.plugins.bitbucketpushandpullrequest.filter.pullrequest.server.BitBucketPPRPullRequestServerTriggerFilter;
import io.jenkins.plugins.bitbucketpushandpullrequest.filter.pullrequest.server.BitBucketPPRPullRequestServerTriggerMatcher;
import io.jenkins.plugins.bitbucketpushandpullrequest.filter.repository.BitBucketPPRRepositoryTriggerFilter;
import io.jenkins.plugins.bitbucketpushandpullrequest.filter.repository.BitBucketPPRRepositoryTriggerMatcher;
import io.jenkins.plugins.bitbucketpushandpullrequest.model.BitBucketPPRHookEvent;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class BitBucketPPRFilterMatcher {
    private static final Logger logger = Logger.getLogger(BitBucketPPRFilterMatcher.class.getName());

    public List<BitBucketPPRTriggerFilter> getMatchingFilters(BitBucketPPRHookEvent event, List<BitBucketPPRTriggerFilter> triggerFilterList) {
        return triggerFilterList.stream().filter(f -> this.matchesEventAndAction(event, (BitBucketPPRTriggerFilter)((Object)f))).collect(Collectors.toList());
    }

    private boolean matchesEventAndAction(BitBucketPPRHookEvent event, BitBucketPPRTriggerFilter triggerFilter) {
        if ("pullrequest".equalsIgnoreCase(event.getEvent()) && triggerFilter instanceof BitBucketPPRPullRequestTriggerFilter) {
            return new BitBucketPPRPullRequestTriggerMatcher().matchesAction(event, triggerFilter);
        }
        if ("pr".equalsIgnoreCase(event.getEvent()) && triggerFilter instanceof BitBucketPPRPullRequestServerTriggerFilter) {
            return new BitBucketPPRPullRequestServerTriggerMatcher().matchesAction(event, triggerFilter);
        }
        if ("repo".equalsIgnoreCase(event.getEvent()) && triggerFilter instanceof BitBucketPPRRepositoryTriggerFilter) {
            return new BitBucketPPRRepositoryTriggerMatcher().matchesAction(event, triggerFilter);
        }
        return false;
    }
}

