/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucketpushandpullrequest.config;

import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import java.util.Collections;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class BitBucketPPRPluginConfig
extends GlobalConfiguration {
    private static final Logger logger = Logger.getLogger(BitBucketPPRPluginConfig.class.getName());
    public static final String BITBUCKET_PPR_PLUGIN_CONFIGURATION_ID = "bitbucket-ppr-plugin-configuration";
    public String hookUrl;
    public boolean notifyBitBucket;
    public boolean useJobNameAsBuildKey;
    public String credentialsId;

    public BitBucketPPRPluginConfig() {
        logger.fine("Read bitbucket push and pull request plugin global configuration.");
        this.notifyBitBucket = true;
        this.load();
    }

    public static BitBucketPPRPluginConfig getInstance() {
        return (BitBucketPPRPluginConfig)((Object)ExtensionList.lookupSingleton(BitBucketPPRPluginConfig.class));
    }

    @DataBoundSetter
    public void setHookUrl(String hookUrl) {
        this.hookUrl = StringUtils.isEmpty((CharSequence)hookUrl) ? "" : hookUrl;
        this.save();
    }

    public boolean isHookUrlSet() {
        return !StringUtils.isEmpty((CharSequence)this.hookUrl);
    }

    public String getHookUrl() {
        return this.hookUrl;
    }

    public boolean shouldNotifyBitBucket() {
        return this.notifyBitBucket;
    }

    @DataBoundSetter
    public void setNotifyBitBucket(@CheckForNull boolean notifyBitBucket) {
        this.notifyBitBucket = notifyBitBucket;
    }

    public boolean shouldUseJobNameAsBuildKey() {
        return this.useJobNameAsBuildKey;
    }

    @DataBoundSetter
    public void setUseJobNameAsBuildKey(@CheckForNull boolean useJobNameAsBuildKey) {
        this.useJobNameAsBuildKey = useJobNameAsBuildKey;
    }

    @DataBoundSetter
    public void setCredentialsId(@CheckForNull String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public String getDisplayName() {
        return "Bitbucket Push and Pull Request";
    }

    public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        req.bindJSON((Object)this, formData);
        this.save();
        return true;
    }

    public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item context, @QueryParameter String remote, @QueryParameter String credentialsId) {
        if (context == null && !Jenkins.get().hasPermission(Jenkins.ADMINISTER) || context != null && !context.hasPermission(Item.EXTENDED_READ)) {
            return new StandardListBoxModel().includeCurrentValue(credentialsId);
        }
        return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM, (ItemGroup)Jenkins.getInstance(), StandardCredentials.class, Collections.emptyList(), CredentialsMatchers.always()).includeCurrentValue(credentialsId);
    }
}

