/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucketpushandpullrequest.common;

import hudson.EnvVars;
import hudson.plugins.git.BranchSpec;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class BitBucketPPRUtils {
    private static final Logger logger = Logger.getLogger(BitBucketPPRUtils.class.getName());

    public static boolean matches(String allBranches, String branchName, EnvVars env) {
        String allowedBranchesPattern = allBranches != null ? allBranches : "";
        logger.fine("Following allowed branches patterns are set: " + allowedBranchesPattern);
        logger.fine("The branchName in action is: " + branchName);
        logger.fine("The environment variables are: " + env);
        BiFunction<List, BiPredicate, List> filter = (list, p) -> {
            ArrayList<String> results = new ArrayList<String>();
            for (String t : list) {
                if (!p.test(t, env)) continue;
                results.add(t);
            }
            return results;
        };
        List matchedBranches = filter.apply(Arrays.asList(allowedBranchesPattern.split(",")), (branchSpec, envVar) -> {
            BranchSpec pattern = new BranchSpec(branchSpec.trim());
            if (envVar == null) {
                return pattern.matches(branchName);
            }
            return pattern.matches(branchName, envVar);
        });
        if (matchedBranches.isEmpty()) {
            logger.info("no matches for allowed branches pattern: " + allowedBranchesPattern);
            return false;
        }
        matchedBranches.forEach(s -> logger.info("Matched branch: " + s));
        return true;
    }

    public static boolean matchWithRegex(@Nonnull String haystack, @Nonnull String patternStr, EnvVars env) {
        if (haystack == null || haystack.trim().isEmpty()) {
            logger.info("The comment from BB is null or it is empty");
            return false;
        }
        if (patternStr == null || patternStr.trim().isEmpty()) {
            logger.fine(String.format("The regex filter on the comment from BB is null or it is empty", new Object[0]));
            return true;
        }
        logger.log(Level.FINEST, "Applying the pattern {0} to the comment {1}", new Object[]{patternStr, haystack});
        Pattern pattern = Pattern.compile(patternStr.trim(), 2);
        return pattern.matcher(haystack.trim()).find();
    }

    public static PrintStream createLoggingProxyForErrors(PrintStream realPrintStream) {
        return new PrintStream(realPrintStream){

            @Override
            public void print(String string) {
                logger.severe(string);
            }

            @Override
            public void println(String string) {
                logger.severe(string);
            }
        };
    }
}

