/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucketpushandpullrequest.client.api;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.github.scribejava.core.model.Verb;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class BitBucketPPRBasicAuthApiConsumer {
    private static final Logger logger = Logger.getLogger(BitBucketPPRBasicAuthApiConsumer.class.getName());

    public HttpResponse send(StandardUsernamePasswordCredentials credentials, Verb verb, String url, String payload) throws IOException, NoSuchMethodException {
        logger.finest("Send state notification with StandardUsernamePasswordCredentials");
        UsernamePasswordCredentials httpAuthCredentials = new UsernamePasswordCredentials(credentials.getUsername(), credentials.getPassword().getPlainText());
        String authHeader = this.getAuthHeader(credentials.getUsername(), credentials.getPassword().getPlainText());
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        provider.setCredentials(AuthScope.ANY, (Credentials)httpAuthCredentials);
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)provider).build();
        if (verb == Verb.POST) {
            HttpPost request = new HttpPost(url);
            request.setHeader("Authorization", authHeader);
            request.setHeader("X-Atlassian-Token", "nocheck");
            if (StringUtils.isNotBlank((CharSequence)payload)) {
                request.setEntity((HttpEntity)new StringEntity(payload, ContentType.APPLICATION_JSON));
            }
            return client.execute((HttpUriRequest)request);
        }
        if (verb == Verb.DELETE) {
            HttpDelete request = new HttpDelete(url);
            request.setHeader("Authorization", authHeader);
            request.setHeader("X-Atlassian-Token", "nocheck");
            return client.execute((HttpUriRequest)request);
        }
        throw new NoSuchMethodException();
    }

    private String getAuthHeader(String username, String password) {
        String auth = username + ":" + password;
        byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(StandardCharsets.ISO_8859_1));
        return "Basic ".concat(new String(encodedAuth, StandardCharsets.ISO_8859_1));
    }
}

