/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucketpushandpullrequest.action;

import hudson.model.InvisibleAction;
import io.jenkins.plugins.bitbucketpushandpullrequest.action.BitBucketPPRAction;
import io.jenkins.plugins.bitbucketpushandpullrequest.model.BitBucketPPRPayload;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class BitBucketPPRPullRequestAction
extends InvisibleAction
implements BitBucketPPRAction {
    @Nonnull
    private final BitBucketPPRPayload payload;
    private List<String> scmUrls = new ArrayList<String>(2);

    public BitBucketPPRPullRequestAction(@Nonnull BitBucketPPRPayload payload) {
        this.payload = payload;
        this.scmUrls.add(payload.getRepository().getLinks().getHtml().getHref());
    }

    @Override
    public String getSourceBranch() {
        return this.payload.getPullRequest().getSource().getBranch().getName();
    }

    @Override
    public String getTargetBranch() {
        return this.payload.getPullRequest().getDestination().getBranch().getName();
    }

    @Override
    public String getLatestCommitFromRef() {
        return this.payload.getPullRequest().getSource().getCommit().getHash();
    }

    @Override
    public String getLatestCommitToRef() {
        return this.payload.getPullRequest().getDestination().getCommit().getHash();
    }

    @Override
    public String getPullRequestUrl() {
        return this.payload.getPullRequest().getLinks().getHtml().getHref();
    }

    @Override
    public String getTitle() {
        return this.payload.getPullRequest().getTitle();
    }

    @Override
    public String getDescription() {
        return this.payload.getPullRequest().getDescription();
    }

    @Override
    public BitBucketPPRPayload getPayload() {
        return this.payload;
    }

    @Override
    public String getScm() {
        return this.payload.getRepository().getScm() != null ? this.payload.getRepository().getScm() : "git";
    }

    @Override
    public String getUser() {
        return this.payload.getActor().getNickname();
    }

    @Override
    public String getRepositoryName() {
        return this.payload.getRepository().getName();
    }

    @Override
    public List<String> getScmUrls() {
        return this.scmUrls;
    }

    @Override
    public String getPullRequestId() {
        return this.payload.getPullRequest().getId();
    }

    @Override
    public String getComment() {
        if (this.payload.getComment() == null || this.payload.getComment().getContent() == null || this.payload.getComment().getContent().getRaw() == null) {
            return "";
        }
        return this.payload.getComment().getContent().getRaw();
    }

    @Override
    public String getLinkHtml() {
        return this.payload.getPullRequest().getLinks().getHtml().getHref();
    }

    @Override
    public String getLinkSelf() {
        return this.payload.getPullRequest().getLinks().getSelf().getHref();
    }

    @Override
    public String getLinkApprove() {
        return this.payload.getPullRequest().getLinks().getApprove().getHref();
    }

    @Override
    public String getLinkDecline() {
        return this.payload.getPullRequest().getLinks().getDecline().getHref();
    }

    @Override
    public String getLinkStatuses() {
        return this.payload.getPullRequest().getLinks().getStatuses().getHref();
    }

    @Override
    public String getLatestCommit() {
        return this.payload.getPullRequest().getSource().getCommit().getHash();
    }

    @Override
    public String getCommitLink() {
        return this.payload.getPullRequest().getSource().getCommit().getLinks().getSelf().getHref();
    }

    public String toString() {
        return "BitBucketPPRPullRequestAction";
    }
}

