/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucketpushandpullrequest;

import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import hudson.Extension;
import hudson.Util;
import hudson.console.AnnotatedLargeText;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.queue.QueueTaskFuture;
import hudson.plugins.git.RevisionParameterAction;
import hudson.scm.PollingResult;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.ListBoxModel;
import hudson.util.SequentialExecutionQueue;
import io.jenkins.plugins.bitbucketpushandpullrequest.BitBucketPPRPollResultListener;
import io.jenkins.plugins.bitbucketpushandpullrequest.BitBucketPPRPollingRunnable;
import io.jenkins.plugins.bitbucketpushandpullrequest.action.BitBucketPPRAction;
import io.jenkins.plugins.bitbucketpushandpullrequest.cause.BitBucketPPRTriggerCause;
import io.jenkins.plugins.bitbucketpushandpullrequest.event.BitBucketPPREventContext;
import io.jenkins.plugins.bitbucketpushandpullrequest.event.BitBucketPPREventFactory;
import io.jenkins.plugins.bitbucketpushandpullrequest.event.BitBucketPPREventType;
import io.jenkins.plugins.bitbucketpushandpullrequest.filter.BitBucketPPRFilterMatcher;
import io.jenkins.plugins.bitbucketpushandpullrequest.filter.BitBucketPPRTriggerFilter;
import io.jenkins.plugins.bitbucketpushandpullrequest.filter.BitBucketPPRTriggerFilterDescriptor;
import io.jenkins.plugins.bitbucketpushandpullrequest.model.BitBucketPPRHookEvent;
import io.jenkins.plugins.bitbucketpushandpullrequest.observer.BitBucketPPRObservable;
import java.io.File;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.triggers.SCMTriggerItem;
import org.apache.commons.jelly.XMLOutput;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class BitBucketPPRTrigger
extends Trigger<Job<?, ?>> {
    private static final String BITBUCKET_POLLING_LOG = "bitbucket-polling.log";
    private static final Logger logger = Logger.getLogger(BitBucketPPRTrigger.class.getName());
    private List<BitBucketPPRTriggerFilter> triggers;
    public static final boolean ALLOW_HOOKURL_OVERRIDE = true;
    public String credentialsId;

    @DataBoundConstructor
    public BitBucketPPRTrigger(List<BitBucketPPRTriggerFilter> triggers) {
        this.triggers = triggers;
    }

    @DataBoundSetter
    public void setCredentialsId(@CheckForNull String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public void onPost(final BitBucketPPRHookEvent bitbucketEvent, final BitBucketPPRAction bitbucketAction, final SCM scmTrigger, final BitBucketPPRObservable observable) throws Exception {
        logger.finest(String.format("Called onPost Method for action %s", bitbucketAction));
        if (this.job == null) {
            logger.warning("Error: the job is null");
            return;
        }
        BitBucketPPRFilterMatcher filterMatcher = new BitBucketPPRFilterMatcher();
        final List<BitBucketPPRTriggerFilter> matchingFilters = filterMatcher.getMatchingFilters(bitbucketEvent, this.triggers);
        if (matchingFilters != null && !matchingFilters.isEmpty()) {
            BitBucketPPRPollingRunnable bitbucketPollingRunnable = new BitBucketPPRPollingRunnable((Job)this.job, this.getLogFile(), new BitBucketPPRPollResultListener(){

                @Override
                public void onPollSuccess(PollingResult pollingResult) {
                    matchingFilters.stream().forEach(filter -> {
                        try {
                            BitBucketPPRTriggerCause cause = filter.getCause(BitBucketPPRTrigger.this.getLogFile(), bitbucketAction, bitbucketEvent);
                            if (BitBucketPPRTrigger.this.shouldScheduleJob(filter, pollingResult, bitbucketAction)) {
                                BitBucketPPRTrigger.this.scheduleJob(cause, bitbucketAction, scmTrigger, observable, filter);
                            }
                        }
                        catch (Throwable e) {
                            logger.warning(String.format("During the polling process an exception was thrown: %s.", e.getMessage()));
                            e.printStackTrace();
                        }
                    });
                }

                @Override
                public void onPollError(Throwable e) {
                    logger.warning(String.format("Called onPollError: %s.", e.getMessage()));
                    e.printStackTrace();
                }
            });
            try {
                this.getDescriptor().queue.execute((Runnable)bitbucketPollingRunnable);
            }
            catch (Throwable e) {
                logger.warning(String.format("Error: cannot add the BB PPR polling runnable to the Jenkins' SequentialExecutionQueue queue: %s", e.getMessage()));
                e.printStackTrace();
            }
        } else {
            logger.warning("Triggers are not configured.");
        }
    }

    private boolean shouldScheduleJob(BitBucketPPRTriggerFilter filter, PollingResult pollingResult, BitBucketPPRAction bitbucketAction) {
        logger.finest(String.format("Should schedule job: %s and (polling result has changes: %s or trigger also if there aren't changes: %s)", filter.shouldScheduleJob(bitbucketAction), pollingResult.hasChanges(), filter.shouldTriggerAlsoIfNothingChanged()));
        return filter.shouldScheduleJob(bitbucketAction) && (pollingResult.hasChanges() || filter.shouldTriggerAlsoIfNothingChanged());
    }

    private void scheduleJob(BitBucketPPRTriggerCause cause, BitBucketPPRAction bitbucketAction, SCM scmTrigger, BitBucketPPRObservable observable, BitBucketPPRTriggerFilter filter) throws URISyntaxException {
        QueueTaskFuture f;
        Queue.Item item = ParameterizedJobMixIn.scheduleBuild2((Job)((Job)this.job), (int)5, (Action[])new Action[]{new CauseAction((Cause)cause), bitbucketAction, new RevisionParameterAction(bitbucketAction.getLatestCommit(), new URIish(bitbucketAction.getScmUrls().get(0)))});
        QueueTaskFuture queueTaskFuture = f = item != null ? item.getFuture() : null;
        if (f == null) {
            return;
        }
        try {
            Run startedBuild = (Run)f.waitForStart();
            logger.info(String.format("Triggering %s # %d", ((Job)this.job).getName(), startedBuild.getNumber()));
            observable.notifyObservers(BitBucketPPREventFactory.createEvent(BitBucketPPREventType.BUILD_STARTED, new BitBucketPPREventContext(this, bitbucketAction, scmTrigger, startedBuild, filter)));
            Run run = (Run)f.get();
            if (f.isDone()) {
                observable.notifyObservers(BitBucketPPREventFactory.createEvent(BitBucketPPREventType.BUILD_FINISHED, new BitBucketPPREventContext(this, bitbucketAction, scmTrigger, run, filter)));
            }
        }
        catch (InterruptedException | ExecutionException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    File getLogFile() {
        if (this.job == null) {
            return null;
        }
        return new File(((Job)this.job).getRootDir(), BITBUCKET_POLLING_LOG);
    }

    public Collection<? extends Action> getProjectActions() {
        return Collections.singleton(new BitBucketPPRWebHookPollingAction());
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public List<BitBucketPPRTriggerFilter> getTriggers() {
        return this.triggers;
    }

    @Symbol(value={"bitBucketTrigger"})
    @Extension
    public static class DescriptorImpl
    extends TriggerDescriptor {
        private final SequentialExecutionQueue queue = new SequentialExecutionQueue(Jenkins.MasterComputer.threadPoolForRemoting);

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item context, @QueryParameter String remote, @QueryParameter String credentialsId) {
            if (context == null && !Jenkins.get().hasPermission(Jenkins.ADMINISTER) || context != null && !context.hasPermission(Item.EXTENDED_READ)) {
                return new StandardListBoxModel().includeCurrentValue(credentialsId);
            }
            return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM, (ItemGroup)Jenkins.getInstance(), StandardCredentials.class, Collections.emptyList(), CredentialsMatchers.always()).includeCurrentValue(credentialsId);
        }

        public boolean isApplicable(Item item) {
            return item instanceof Job && SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem((Item)item) != null && item instanceof ParameterizedJobMixIn.ParameterizedJob;
        }

        public String getDisplayName() {
            return "Build with BitBucket Push and Pull Request Plugin";
        }

        public List<BitBucketPPRTriggerFilterDescriptor> getTriggerDescriptors() {
            return Jenkins.get().getDescriptorList(BitBucketPPRTriggerFilter.class);
        }
    }

    public class BitBucketPPRWebHookPollingAction
    implements Action {
        public Job<?, ?> getOwner() {
            return (Job)BitBucketPPRTrigger.this.job;
        }

        public String getIconFileName() {
            return "clipboard.png";
        }

        public String getDisplayName() {
            return "BitBucket Push and Pull Request Hook Log";
        }

        public String getUrlName() {
            return "BitBucketPPRPollLog";
        }

        public String getLog() throws Exception {
            return Util.loadFile((File)BitBucketPPRTrigger.this.getLogFile(), (Charset)StandardCharsets.UTF_8);
        }

        public void writeLogTo(XMLOutput out) throws Exception {
            new AnnotatedLargeText(BitBucketPPRTrigger.this.getLogFile(), Charset.defaultCharset(), true, (Object)this).writeHtmlTo(0L, out.asWriter());
        }
    }
}

