/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.benchmark;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Build;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import io.jenkins.plugins.benchmark.BenchmarkAction;
import io.jenkins.plugins.benchmark.BenchmarkConfigAction;
import io.jenkins.plugins.benchmark.BenchmarkResultAction;
import io.jenkins.plugins.benchmark.Messages;
import io.jenkins.plugins.benchmark.configuration.BenchmarkConfiguration;
import io.jenkins.plugins.benchmark.configuration.ConfigEntry;
import io.jenkins.plugins.benchmark.data.BenchmarkResults;
import io.jenkins.plugins.benchmark.data.ReadResult;
import io.jenkins.plugins.benchmark.data.Reader;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import javax.servlet.ServletException;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class BenchmarkBuilder
extends Builder
implements SimpleBuildStep {
    private static transient Set<Integer> ids = new HashSet<Integer>();
    private final String filepath;
    private AbstractProject<?, ?> project;
    private final int randomNr;
    private transient BenchmarkConfiguration bc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DataBoundConstructor
    public BenchmarkBuilder(String filepath) {
        int r;
        this.filepath = filepath;
        Set<Integer> set = ids;
        synchronized (set) {
            while (ids.contains(r = new Random().nextInt(Integer.MAX_VALUE))) {
            }
            ids.add(r);
        }
        this.randomNr = r;
    }

    public String getFilepath() {
        return this.filepath;
    }

    @SuppressFBWarnings(value={"NS_DANGEROUS_NON_SHORT_CIRCUIT"})
    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        boolean succes = false;
        ReadResult m = null;
        try {
            m = new BenchmarkResults(this.filepath).read();
        }
        catch (BenchmarkResults.WrongFormatException | Reader.InputException e) {
            listener.getLogger().println(e.getMessage());
        }
        if (m != null && m.getException() != null) {
            listener.getLogger().println(m.getException());
        }
        BenchmarkConfiguration conf = this.getConfig(run);
        if (m == null || m.getMessurements() == null) {
            listener.getLogger().println(Messages.read_error(this.filepath));
            run.setResult(Result.FAILURE);
        } else {
            listener.getLogger().println(Messages.read_succes());
            boolean tb = this.timeIsBetter(listener.getLogger(), conf, m.getMessurements());
            Map<String, Double> lastResults = null;
            BenchmarkAction a = this.getPreviousBenchmarkAction(run);
            if (a != null) {
                lastResults = a.getResults();
            }
            if (!tb | !this.percentIsBetter(listener.getLogger(), conf, m.getMessurements(), lastResults)) {
                run.setResult(Result.FAILURE);
            } else {
                for (String k : m.getMessurements().keySet()) {
                    conf.add(k, new ConfigEntry(null, null, null, null, null, Integer.parseInt(run.getDisplayName().substring(1))));
                }
                run.setResult(Result.SUCCESS);
                succes = true;
            }
        }
        BenchmarkAction bA = new BenchmarkAction(m, this, succes, conf.copy());
        run.addAction((Action)bA);
    }

    public BenchmarkConfiguration getConfig(Run<?, ?> run) {
        if (this.bc == null) {
            this.bc = BenchmarkConfiguration.getConfig(this.getCurrentWorkspace(run) + "config" + this.getID() + ".config");
            return this.bc;
        }
        return this.bc;
    }

    public BenchmarkConfiguration getConfig(AbstractProject<?, ?> project) {
        if (this.bc == null) {
            this.bc = BenchmarkConfiguration.getConfig(project.getRootDir().getAbsolutePath() + File.separator + "config" + this.getID() + ".config");
            return this.bc;
        }
        return this.bc;
    }

    private String getCurrentWorkspace(Run<?, ?> run) {
        String s = run.getRootDir().getAbsolutePath();
        s = s.substring(0, s.lastIndexOf(File.separator));
        s = s.substring(0, s.lastIndexOf(File.separator) + 1);
        return s;
    }

    private BenchmarkAction getPreviousBenchmarkAction(Run<?, ?> run) {
        Run o = run.getPreviousSuccessfulBuild();
        if (o != null && o instanceof Build) {
            Optional<BenchmarkAction> l = ((Build)o).getActions(BenchmarkAction.class).stream().filter(x -> x.getBenchmarkBuilder().equals((Object)this)).findFirst();
            return l.isPresent() ? l.get() : null;
        }
        return null;
    }

    private boolean timeIsBetter(PrintStream printStream, BenchmarkConfiguration conf, Map<String, Double> m) {
        boolean better = true;
        for (Map.Entry<String, Double> e : m.entrySet()) {
            String key = e.getKey();
            ConfigEntry c = conf.get(key);
            if (c == null) continue;
            Double curValue = e.getValue();
            Double maxV = c.getMaxValue();
            Double minV = c.getMinValue();
            if (maxV != null && maxV + 1.0E-11 < curValue) {
                printStream.println(Messages.valueToHigh(key, curValue, maxV, c.getUnitName()));
                better = false;
            }
            if (minV == null || !(minV - 1.0E-11 > curValue)) continue;
            printStream.println(Messages.valueToLow(key, curValue, minV, c.getUnitName()));
            better = false;
        }
        return better;
    }

    private boolean percentIsBetter(PrintStream printStream, BenchmarkConfiguration conf, Map<String, Double> m, Map<String, Double> lastResults) {
        boolean better = true;
        if (lastResults == null) {
            return better;
        }
        for (Map.Entry<String, Double> e : m.entrySet()) {
            String key = e.getKey();
            ConfigEntry c = conf.get(key);
            if (c == null) continue;
            Double lastValue = lastResults.get(e.getKey());
            Double curValue = e.getValue();
            Double maxP = c.getMaxPercent();
            Double minP = c.getMinPercent();
            if (lastValue == null) continue;
            if (lastValue != 0.0) {
                double percent = this.calculateChange(lastValue, curValue) * 100.0;
                if (maxP != null && maxP + 1.0E-11 < percent) {
                    printStream.println(Messages.higherThanLastTime(key, percent, maxP));
                    better = false;
                    continue;
                }
                if (minP == null || !(minP - 1.0E-11 > percent)) continue;
                printStream.println(Messages.lowerThanLastTime(key, percent, minP));
                better = false;
                continue;
            }
            if (curValue > 0.0 && maxP != null || curValue == 0.0 && maxP != null && maxP < 0.0) {
                printStream.println(Messages.higherThanExpected(key, maxP));
                better = false;
                continue;
            }
            if (!(curValue < 0.0 && minP != null) && (curValue != 0.0 || minP == null || !(minP > 0.0))) continue;
            printStream.println(Messages.lowerThanExpected(key, minP));
            better = false;
        }
        return better;
    }

    private Double calculateChange(double prev, double now) {
        double r = now / prev - 1.0;
        if (now > prev && r > 0.0 || now == prev && r == 0.0 || now < prev && r < 0.0) {
            return r;
        }
        return r * -1.0;
    }

    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> project) {
        ArrayList<Object> actions = new ArrayList<Object>();
        if (this.project == null) {
            this.project = project;
        } else if (project != this.project) {
            return actions;
        }
        actions.addAll(super.getProjectActions(project));
        actions.add(new BenchmarkResultAction(project, this));
        actions.add(new BenchmarkConfigAction(this.getConfig(project), project));
        return actions;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BenchmarkBuilder) {
            BenchmarkBuilder b = (BenchmarkBuilder)((Object)obj);
            return this.getFilepath().equals(b.getFilepath()) && this.randomNr == b.randomNr;
        }
        return false;
    }

    public int hashCode() {
        return this.randomNr + this.filepath.hashCode();
    }

    public int getID() {
        return this.randomNr;
    }

    @Symbol(value={"benchmark"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public FormValidation doCheckFilepath(@QueryParameter String filepath) throws IOException, ServletException {
            boolean web;
            File f = new File(filepath);
            if (f.exists() && f.isDirectory()) {
                return FormValidation.error((String)Messages.fileIsDir());
            }
            String ending = null;
            for (String end : BenchmarkResults.endings) {
                if (!filepath.toLowerCase().endsWith("." + end)) continue;
                ending = end;
            }
            if (ending == null) {
                return FormValidation.error((String)Messages.wrongFormat(BenchmarkResults.getFormats()));
            }
            boolean bl = web = filepath.toLowerCase().startsWith("http") || filepath.toLowerCase().startsWith("ftp");
            if (!web) {
                int lastI = filepath.lastIndexOf(File.separator);
                if (lastI == -1) {
                    return FormValidation.warning((String)Messages.noFile());
                }
                if (filepath.substring(filepath.lastIndexOf(File.separatorChar) + 1, filepath.lastIndexOf("." + ending)).length() == 0) {
                    return FormValidation.warning((String)Messages.noFileName());
                }
                if (!f.exists()) {
                    return FormValidation.warning((String)Messages.fileIsNotPresent());
                }
            }
            Map<String, Double> m = null;
            try {
                ReadResult r = new BenchmarkResults(filepath).read();
                if (r != null) {
                    if (r.getException() != null) {
                        return FormValidation.error((String)r.getException());
                    }
                    m = r.getMessurements();
                }
            }
            catch (Reader.InputException e) {
                return FormValidation.error((String)e.getMessage());
            }
            catch (BenchmarkResults.WrongFormatException wrongFormatException) {
                // empty catch block
            }
            if (m == null) {
                return FormValidation.error((String)Messages.read_error(filepath));
            }
            return FormValidation.ok();
        }

        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return Messages.benchmark();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

