/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.jenkins.plugins.sam.export;

import com.amazonaws.jenkins.plugins.sam.export.BucketProperties;

public enum ArtifactResources {
    SERVERLESS_FUNCTION("AWS::Serverless::Function", "CodeUri", true, true),
    SERVERLESS_API("AWS::Serverless::Api", "DefinitionUri", false),
    APP_SYNC_GRAPHQL_SCHEMA("AWS::AppSync::GraphQLSchema", "DefinitionS3Location"),
    API_GATEWAY_REST_API("AWS::ApiGateway::RestApi", "BodyS3Location", false, false, BucketProperties.BUCKET),
    LAMBDA_FUNCTION("AWS::Lambda::Function", "Code", true, true, BucketProperties.S3_BUCKET),
    ELASTIC_BEANSTALK_APPLICATION_VERSION("AWS::ElasticBeanstalk::ApplicationVersion", "SourceBundle", true, false, BucketProperties.S3_BUCKET_NO_VERSION),
    CLOUD_FORMATION_STACK("AWS::CloudFormation::Stack", "TemplateURL");

    private final String type;
    private final String artifactsPathProperty;
    private final boolean workspacePackageAllowed;
    private final boolean forceZip;
    private final BucketProperties bucketProperties;

    private ArtifactResources(String type, String artifactsPathPropery) {
        this(type, artifactsPathPropery, true);
    }

    private ArtifactResources(String type, String artifactsPathProperty, boolean workspacePackageAllowed) {
        this(type, artifactsPathProperty, workspacePackageAllowed, false);
    }

    private ArtifactResources(String type, String artifactsPathProperty, boolean workspacePackageAllowed, boolean forceZip) {
        this(type, artifactsPathProperty, workspacePackageAllowed, forceZip, null);
    }

    private ArtifactResources(String type, String artifactsPathProperty, boolean workspacePackageAllowed, boolean forceZip, BucketProperties bucketProperties) {
        this.type = type;
        this.artifactsPathProperty = artifactsPathProperty;
        this.workspacePackageAllowed = workspacePackageAllowed;
        this.forceZip = forceZip;
        this.bucketProperties = bucketProperties;
    }

    public String getType() {
        return this.type;
    }

    public String getArtifactsPathProperty() {
        return this.artifactsPathProperty;
    }

    public boolean isWorkspacePackageAllowed() {
        return this.workspacePackageAllowed;
    }

    public boolean isForceZip() {
        return this.forceZip;
    }

    public BucketProperties getBucketProperties() {
        return this.bucketProperties;
    }

    public boolean hasBucketProperties() {
        return this.bucketProperties != null;
    }

    public static ArtifactResources fromType(String resourceType) {
        for (ArtifactResources resource : ArtifactResources.values()) {
            if (!resource.getType().equals(resourceType)) continue;
            return resource;
        }
        throw new IllegalArgumentException("Cannot create enum from " + resourceType + " value!");
    }
}

