/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.trigger.register;

import java.util.Objects;

public class WebhookRegisterRequest {
    private static final int MAX_WEBHOOK_NAME_LENGTH = 255;
    private final String jenkinsUrl;
    private final boolean isMirror;
    private final String name;
    private final String projectKey;
    private final String repoSlug;
    private final boolean triggerOnPullRequest;
    private final boolean triggerOnRefChange;

    public WebhookRegisterRequest(Builder builder) {
        this.projectKey = Objects.requireNonNull(builder.projectKey);
        this.repoSlug = Objects.requireNonNull(builder.repoSlug);
        this.name = Objects.requireNonNull(builder.serverId);
        this.jenkinsUrl = Objects.requireNonNull(builder.jenkinsUrl);
        this.isMirror = builder.isMirror;
        this.triggerOnRefChange = builder.triggerOnRefChange;
        this.triggerOnPullRequest = builder.triggerOnPullRequest;
    }

    public String getName() {
        return this.name;
    }

    public String getJenkinsUrl() {
        return this.jenkinsUrl;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public String getRepoSlug() {
        return this.repoSlug;
    }

    public boolean isMirror() {
        return this.isMirror;
    }

    public boolean isTriggerOnPullRequest() {
        return this.triggerOnPullRequest;
    }

    public boolean isTriggerOnRefChange() {
        return this.triggerOnRefChange;
    }

    public static class Builder {
        private final String projectKey;
        private final String repoSlug;
        private boolean isMirror;
        private String jenkinsUrl;
        private String serverId;
        private boolean triggerOnPullRequest;
        private boolean triggerOnRefChange;

        private Builder(String projectKey, String repoSlug) {
            this.projectKey = projectKey;
            this.repoSlug = repoSlug;
        }

        public static Builder aRequest(String project, String repoSlug) {
            return new Builder(project, repoSlug);
        }

        public WebhookRegisterRequest build() {
            return new WebhookRegisterRequest(this);
        }

        public Builder isMirror(boolean isMirror) {
            this.isMirror = isMirror;
            return this;
        }

        public Builder shouldTriggerOnPullRequest(boolean triggerOnPullRequest) {
            this.triggerOnPullRequest = triggerOnPullRequest;
            return this;
        }

        public Builder shouldTriggerOnRefChange(boolean triggerOnRefChange) {
            this.triggerOnRefChange = triggerOnRefChange;
            return this;
        }

        public Builder withJenkinsBaseUrl(String jenkinsUrl) {
            this.jenkinsUrl = jenkinsUrl;
            return this;
        }

        public Builder withName(String name) {
            if (name.length() > 255) {
                throw new IllegalArgumentException(String.format("Webhook name should be less than %d characters", 255));
            }
            this.serverId = name;
            return this;
        }
    }
}

