/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.scm.trait;

import com.atlassian.bitbucket.jenkins.internal.client.BitbucketBranchClient;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketClientFactory;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketClientFactoryProvider;
import com.atlassian.bitbucket.jenkins.internal.config.BitbucketPluginConfiguration;
import com.atlassian.bitbucket.jenkins.internal.config.BitbucketServerConfiguration;
import com.atlassian.bitbucket.jenkins.internal.credentials.JenkinsToBitbucketCredentials;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketBranchSCMHead;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMHeadDiscoveryHandler;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMRepository;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMRevision;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMSource;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMSourceContext;
import com.atlassian.bitbucket.jenkins.internal.scm.Messages;
import hudson.Extension;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.inject.Inject;
import jenkins.plugins.git.GitSCMBuilder;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.trait.SCMBuilder;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import jenkins.scm.impl.trait.Discovery;
import org.kohsuke.stapler.DataBoundConstructor;

public class BitbucketBranchDiscoveryTrait
extends SCMSourceTrait {
    private static final Logger log = Logger.getLogger(BitbucketBranchDiscoveryTrait.class.getName());

    @DataBoundConstructor
    public BitbucketBranchDiscoveryTrait() {
    }

    protected void decorateContext(SCMSourceContext<?, ?> context) {
        if (context instanceof BitbucketSCMSourceContext) {
            final BitbucketSCMSourceContext bitbucketContext = (BitbucketSCMSourceContext)context;
            DescriptorImpl descriptor = (DescriptorImpl)this.getDescriptor();
            Optional<BitbucketClientFactory> clientFactory = descriptor.getClientFactory(bitbucketContext);
            if (!clientFactory.isPresent()) {
                log.log(Level.WARNING, "Server configuration missing, cannot resolve client for Branch discovery");
                return;
            }
            BitbucketSCMRepository repository = bitbucketContext.getRepository();
            final BitbucketBranchClient bitbucketBranchClient = clientFactory.get().getProjectClient(repository.getProjectKey()).getRepositoryClient(repository.getRepositorySlug()).getBranchClient(bitbucketContext.getTaskListener());
            bitbucketContext.withDiscoveryHandler(new BitbucketSCMHeadDiscoveryHandler(){

                @Override
                public Stream<? extends SCMHead> discoverHeads() {
                    if (bitbucketContext.getEventHeads().isEmpty()) {
                        return bitbucketBranchClient.getRemoteBranches().map(BitbucketBranchSCMHead::new);
                    }
                    return bitbucketContext.getEventHeads().stream().filter(BitbucketBranchSCMHead.class::isInstance);
                }

                @Override
                public SCMRevision toRevision(SCMHead head) {
                    if (head instanceof BitbucketBranchSCMHead) {
                        return new BitbucketSCMRevision((BitbucketBranchSCMHead)head, ((BitbucketBranchSCMHead)head).getLatestCommit());
                    }
                    IllegalStateException e = new IllegalStateException("The specified head needs to be an instance of BitbucketBranchSCMHead");
                    e.setStackTrace(new StackTraceElement[0]);
                    throw e;
                }
            });
        }
    }

    @Discovery
    @Extension
    public static class DescriptorImpl
    extends SCMSourceTraitDescriptor {
        @Inject
        private BitbucketClientFactoryProvider bitbucketClientFactoryProvider;
        @Inject
        private BitbucketPluginConfiguration bitbucketPluginConfiguration;
        @Inject
        private JenkinsToBitbucketCredentials jenkinsToBitbucketCredentials;

        public Class<? extends SCMBuilder> getBuilderClass() {
            return GitSCMBuilder.class;
        }

        public Optional<BitbucketClientFactory> getClientFactory(BitbucketSCMSourceContext bitbucketContext) {
            return this.bitbucketPluginConfiguration.getServerById(bitbucketContext.getRepository().getServerId()).map(BitbucketServerConfiguration::getBaseUrl).map(baseUrl -> this.bitbucketClientFactoryProvider.getClient((String)baseUrl, this.jenkinsToBitbucketCredentials.toBitbucketCredentials(bitbucketContext.getCredentials())));
        }

        public Class<? extends SCMSourceContext> getContextClass() {
            return BitbucketSCMSourceContext.class;
        }

        public String getDisplayName() {
            return Messages.bitbucket_scm_trait_discovery_branches_display();
        }

        public Class<? extends SCMSource> getSourceClass() {
            return BitbucketSCMSource.class;
        }
    }
}

