/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.scm;

import com.atlassian.bitbucket.jenkins.internal.model.BitbucketRefChange;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketTag;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMHead;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMRevision;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMSource;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import jenkins.plugins.git.GitTagSCMHead;
import jenkins.plugins.git.GitTagSCMRevision;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadMigration;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.mixin.TagSCMHead;

public class BitbucketTagSCMHead
extends BitbucketSCMHead
implements TagSCMHead {
    private static final String REFS_TAGS_PREFIX = "refs/tags/";
    private static final long UNKNOWN_TIMESTAMP = -1L;

    public BitbucketTagSCMHead(String name) {
        super(name, null, -1L);
    }

    public BitbucketTagSCMHead(BitbucketTag tag) {
        super(tag.getDisplayId(), tag.getLatestCommit(), -1L);
    }

    public BitbucketTagSCMHead(BitbucketRefChange refChange) {
        super(refChange.getRef().getDisplayId(), refChange.getToHash(), -1L);
    }

    @Override
    public String getFullRef() {
        return REFS_TAGS_PREFIX + this.getName();
    }

    public long getTimestamp() {
        return -1L;
    }

    @Extension
    public static class SCMHeadMigrationImpl
    extends SCMHeadMigration<BitbucketSCMSource, GitTagSCMHead, GitTagSCMRevision> {
        public SCMHeadMigrationImpl() {
            super(BitbucketSCMSource.class, GitTagSCMHead.class, GitTagSCMRevision.class);
        }

        public SCMHead migrate(@NonNull BitbucketSCMSource source, @NonNull GitTagSCMHead head) {
            return new BitbucketTagSCMHead(head.getName());
        }

        public SCMRevision migrate(@NonNull BitbucketSCMSource source, @NonNull GitTagSCMRevision revision) {
            return new BitbucketSCMRevision(new BitbucketTagSCMHead(revision.getHead().getName()), revision.getHash());
        }
    }
}

