/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.scm;

import com.atlassian.bitbucket.jenkins.internal.client.BitbucketFilePathClient;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMHead;
import java.io.IOException;
import java.util.Objects;
import jenkins.scm.api.SCMFile;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMProbe;
import jenkins.scm.api.SCMProbeStat;

public class BitbucketSCMProbe
extends SCMProbe {
    private final BitbucketFilePathClient filePathClient;
    private final SCMHead head;

    public BitbucketSCMProbe(SCMHead head, BitbucketFilePathClient filePathClient) {
        this.filePathClient = Objects.requireNonNull(filePathClient, "filePathClient");
        this.head = Objects.requireNonNull(head, "head");
    }

    public void close() throws IOException {
    }

    public String name() {
        return this.head.getName();
    }

    public long lastModified() {
        if (this.head instanceof BitbucketSCMHead) {
            return ((BitbucketSCMHead)this.head).getUpdatedDate();
        }
        return -1L;
    }

    public SCMProbeStat stat(String path) throws IOException {
        Objects.requireNonNull(path, "path");
        return SCMProbeStat.fromType((SCMFile.Type)this.filePathClient.getFileType(path, this.getRef()));
    }

    private String getRef() {
        String latestCommit;
        if (this.head instanceof BitbucketSCMHead && (latestCommit = ((BitbucketSCMHead)this.head).getLatestCommit()) != null) {
            return latestCommit;
        }
        return this.head.getName();
    }
}

