/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.jenkins.oauth.consumer;

import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.consumer.Consumer;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.consumer.ServiceProviderConsumerStore;
import com.atlassian.bitbucket.jenkins.internal.jenkins.oauth.consumer.Messages;
import com.atlassian.bitbucket.jenkins.internal.provider.JenkinsProvider;
import com.atlassian.bitbucket.jenkins.internal.util.FormValidationUtils;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import javax.inject.Inject;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class OAuthConsumerEntry
extends AbstractDescribableImpl<OAuthConsumerEntry> {
    private static String CONSUMER_KEY_FIELD = "consumerKey";
    private static String CONSUMER_NAME_FIELD = "consumerName";
    private static String CONSUMER_SECRET_FIELD = "consumerSecret";
    private static String CONSUMER_CALLBACKURL_FIELD = "callbackUrl";
    private static final OAuthConsumerEntry BLANK_ENTRY = new OAuthConsumerEntry(Consumer.key("Enter Key").name("Enter Name").signatureMethod(Consumer.SignatureMethod.HMAC_SHA1).build(), false);
    private final Consumer consumer;
    private final boolean isUpdate;

    public OAuthConsumerEntry(Consumer consumer, boolean isUpdate) {
        this.consumer = consumer;
        this.isUpdate = isUpdate;
    }

    public static OAuthConsumerEntry getOAuthConsumerForAdd() {
        return BLANK_ENTRY;
    }

    public static OAuthConsumerEntry getOAuthConsumerForUpdate(Consumer consumer) {
        return new OAuthConsumerEntry(consumer, true);
    }

    public String getCallbackUrl() {
        return this.isCallbackUrlSet() ? this.consumer.getCallback().get().toString() : "";
    }

    public boolean isCallbackUrlSet() {
        return this.consumer.getCallback().isPresent();
    }

    public String getConsumerKey() {
        return this.consumer.getKey();
    }

    public String getConsumerName() {
        return this.consumer.getName();
    }

    public String getConsumerSecret() {
        return this.consumer.getConsumerSecret().orElse("");
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    public OAuthConsumerEntryDescriptor getDescriptor() {
        return (OAuthConsumerEntryDescriptor)super.getDescriptor();
    }

    @Extension
    public static class OAuthConsumerEntryDescriptor
    extends Descriptor<OAuthConsumerEntry> {
        @Inject
        private JenkinsProvider jenkinsProvider;
        @Inject
        private ServiceProviderConsumerStore consumerStore;

        public FormValidation doCheckConsumerKey(@QueryParameter String consumerKey) {
            this.jenkinsProvider.get().checkPermission(Jenkins.ADMINISTER);
            if (StringUtils.isBlank((CharSequence)consumerKey)) {
                return FormValidation.error((String)"Consumer key cannot be empty");
            }
            if (!StringUtils.isAlphanumeric((CharSequence)consumerKey.replaceAll("-", ""))) {
                return FormValidation.error((String)"Consumer key must consist of alphanumeric characters and hyphens only");
            }
            if (this.consumerStore.get(consumerKey).isPresent()) {
                return FormValidation.error((String)"Key with the same name already exists");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckConsumerName(@QueryParameter String consumerName) {
            this.jenkinsProvider.get().checkPermission(Jenkins.ADMINISTER);
            if (StringUtils.isBlank((CharSequence)consumerName)) {
                return FormValidation.error((String)"Consumer name cannot be empty");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckCallbackUrl(@QueryParameter String callbackUrl) {
            this.jenkinsProvider.get().checkPermission(Jenkins.ADMINISTER);
            return FormValidationUtils.checkBaseUrl(callbackUrl);
        }

        public FormValidation doCheckConsumerSecret(@QueryParameter String consumerSecret) {
            this.jenkinsProvider.get().checkPermission(Jenkins.ADMINISTER);
            if (StringUtils.isBlank((CharSequence)consumerSecret)) {
                return FormValidation.error((String)"Consumer secret cannot be empty");
            }
            return FormValidation.ok();
        }

        public Consumer getConsumerFromSubmittedForm(StaplerRequest request) throws ServletException, URISyntaxException, Descriptor.FormException {
            this.jenkinsProvider.get().checkPermission(Jenkins.ADMINISTER);
            JSONObject data = request.getSubmittedForm();
            String consumerKey = data.getString(CONSUMER_KEY_FIELD);
            String consumerName = data.getString(CONSUMER_NAME_FIELD);
            String consumerSecret = data.getString(CONSUMER_SECRET_FIELD);
            String callbackUrl = data.getString(CONSUMER_CALLBACKURL_FIELD);
            FormValidation formValidation = FormValidation.aggregate(Arrays.asList(this.doCheckConsumerKey(consumerKey), this.doCheckConsumerName(consumerName), this.doCheckCallbackUrl(callbackUrl), this.doCheckConsumerSecret(consumerSecret)));
            if (formValidation.kind == FormValidation.Kind.ERROR) {
                throw new Descriptor.FormException(Messages.bitbucket_oauth_consumer_entry_form_error() + "\n" + formValidation.getMessage(), CONSUMER_KEY_FIELD);
            }
            Consumer.Builder builder = Consumer.key(consumerKey).name(consumerName).consumerSecret(consumerSecret).signatureMethod(Consumer.SignatureMethod.HMAC_SHA1);
            if (!StringUtils.isBlank((CharSequence)callbackUrl)) {
                builder.callback(new URI(callbackUrl));
            }
            return builder.build();
        }
    }
}

