/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.jenkins.auth;

import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.auth.TrustedUnderlyingSystemAuthorizerFilter;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.exception.NoSuchUserException;
import hudson.model.User;
import hudson.security.ACL;
import hudson.security.ACLContext;
import java.io.IOException;
import java.util.Objects;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TrustedJenkinsAuthorizer
implements TrustedUnderlyingSystemAuthorizerFilter {
    private static final Logger log = Logger.getLogger(TrustedJenkinsAuthorizer.class.getName());

    @Override
    public void authorize(String userName, HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException, NoSuchUserException {
        Objects.requireNonNull(userName, "userName");
        User u = this.getUser(userName);
        if (u != null) {
            try (ACLContext ignored = this.createACLContext(u);){
                log.info("Successfully logged in as user " + userName);
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        } else {
            throw new NoSuchUserException(String.format("No such user %s in the system", userName));
        }
    }

    @CheckForNull
    User getUser(String userName) {
        return User.getById((String)userName, (boolean)false);
    }

    ACLContext createACLContext(User u) {
        return ACL.as((User)u);
    }
}

