/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.deployments;

import com.atlassian.bitbucket.jenkins.internal.deployments.DeploymentStepImpl;
import com.atlassian.bitbucket.jenkins.internal.model.deployment.BitbucketDeployment;
import com.atlassian.bitbucket.jenkins.internal.model.deployment.BitbucketDeploymentEnvironment;
import com.atlassian.bitbucket.jenkins.internal.model.deployment.DeploymentState;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMRepository;
import com.atlassian.bitbucket.jenkins.internal.status.BitbucketRevisionAction;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public class DeploymentStepExecutionCallback
extends BodyExecutionCallback {
    private static final Logger LOGGER = Logger.getLogger(DeploymentStepExecutionCallback.class.getName());
    private static final long serialVersionUID = 1L;
    private final BitbucketDeploymentEnvironment environment;

    public DeploymentStepExecutionCallback(BitbucketDeploymentEnvironment environment) {
        this.environment = environment;
    }

    public void onStart(StepContext context) {
        this.sendNotification(context, DeploymentState.IN_PROGRESS);
    }

    public void onSuccess(StepContext context, Object result) {
        this.sendNotification(context, DeploymentState.SUCCESSFUL);
        context.onSuccess(result);
    }

    public void onFailure(StepContext context, Throwable t) {
        this.sendNotification(context, DeploymentState.FAILED);
        context.onFailure(t);
    }

    BitbucketDeploymentEnvironment getEnvironment() {
        return this.environment;
    }

    DeploymentStepImpl.DescriptorImpl getStepDescriptor() {
        DeploymentStepImpl.DescriptorImpl stepDescriptor = (DeploymentStepImpl.DescriptorImpl)Jenkins.get().getDescriptorByType(DeploymentStepImpl.DescriptorImpl.class);
        if (stepDescriptor == null) {
            throw new IllegalStateException("Cannot get descriptor for DeploymentStepImpl.DescriptorImpl");
        }
        return stepDescriptor;
    }

    private void sendNotification(StepContext context, DeploymentState state) {
        TaskListener listener;
        try {
            listener = (TaskListener)context.get(TaskListener.class);
        }
        catch (Exception e) {
            LOGGER.warning(this.getErrorMessage(e.getMessage()));
            return;
        }
        if (listener == null) {
            LOGGER.warning(this.getErrorMessage("No TaskListener in the StepContext"));
            return;
        }
        try {
            Run run = (Run)context.get(Run.class);
            if (run == null) {
                LOGGER.warning(this.getErrorMessage("No Run in the StepContext"));
                return;
            }
            BitbucketRevisionAction revisionAction = (BitbucketRevisionAction)run.getAction(BitbucketRevisionAction.class);
            if (revisionAction == null) {
                listener.error(this.getErrorMessage("The Run is not using Bitbucket SCM for checkout"));
                return;
            }
            BitbucketDeployment deployment = this.getStepDescriptor().getBitbucketDeploymentFactory().createDeployment(run, this.environment, state);
            BitbucketSCMRepository bitbucketSCMRepo = revisionAction.getBitbucketSCMRepo();
            String revisionSha = revisionAction.getRevisionSha1();
            this.getStepDescriptor().getDeploymentPoster().postDeployment(bitbucketSCMRepo, revisionSha, deployment, run, listener);
        }
        catch (Exception e) {
            listener.error(this.getErrorMessage(e.getMessage()));
        }
    }

    private String getErrorMessage(String e) {
        return String.format("There was an error sending the deployment information to Bitbucket Server: %s", e);
    }
}

