/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.client;

import com.atlassian.bitbucket.jenkins.internal.client.BitbucketDeploymentClient;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketRequestExecutor;
import com.atlassian.bitbucket.jenkins.internal.client.RequestConfiguration;
import com.atlassian.bitbucket.jenkins.internal.model.deployment.BitbucketDeployment;
import java.util.Objects;
import okhttp3.HttpUrl;
import org.apache.commons.lang3.StringUtils;

public class BitbucketDeploymentClientImpl
implements BitbucketDeploymentClient {
    private final BitbucketRequestExecutor bitbucketRequestExecutor;
    private final String projectKey;
    private final String repoSlug;
    private final String revisionSha;

    public BitbucketDeploymentClientImpl(BitbucketRequestExecutor bitbucketRequestExecutor, String projectKey, String repoSlug, String revisionSha) {
        this.bitbucketRequestExecutor = Objects.requireNonNull(bitbucketRequestExecutor, "bitbucketRequestExecutor");
        this.projectKey = Objects.requireNonNull(StringUtils.stripToNull((String)projectKey), "projectKey");
        this.repoSlug = Objects.requireNonNull(StringUtils.stripToNull((String)repoSlug), "repoSlug");
        this.revisionSha = Objects.requireNonNull(StringUtils.stripToNull((String)revisionSha), "revisionSha");
    }

    @Override
    public void post(BitbucketDeployment deployment) {
        HttpUrl url = this.bitbucketRequestExecutor.getBaseUrl().newBuilder().addPathSegment("rest").addPathSegment("api").addPathSegment("1.0").addPathSegment("projects").addPathSegment(this.projectKey).addPathSegment("repos").addPathSegment(this.repoSlug).addPathSegment("commits").addPathSegment(this.revisionSha).addPathSegment("deployments").build();
        this.bitbucketRequestExecutor.makePostRequest(url, deployment, new RequestConfiguration[0]);
    }
}

