/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.trigger;

import com.atlassian.bitbucket.jenkins.internal.config.BitbucketPluginConfiguration;
import com.atlassian.bitbucket.jenkins.internal.trigger.Messages;
import com.atlassian.bitbucket.jenkins.internal.trigger.RetryingWebhookHandler;
import com.atlassian.bitbucket.jenkins.internal.trigger.events.AbstractWebhookEvent;
import com.atlassian.bitbucket.jenkins.internal.trigger.events.PullRequestFromRefUpdatedWebhookEvent;
import com.atlassian.bitbucket.jenkins.internal.trigger.events.PullRequestOpenedWebhookEvent;
import com.atlassian.bitbucket.jenkins.internal.trigger.events.PullRequestWebhookEvent;
import com.atlassian.bitbucket.jenkins.internal.trigger.events.RefsChangedWebhookEvent;
import com.google.common.annotations.VisibleForTesting;
import hudson.Extension;
import hudson.model.Item;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import java.util.logging.Logger;
import javax.inject.Inject;
import jenkins.branch.MultiBranchProject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class BitbucketWebhookMultibranchTrigger
extends Trigger<MultiBranchProject<?, ?>> {
    private static final int BUILD_ON_PULL_REQUEST_VERSION = 1;
    private static final Logger LOGGER = Logger.getLogger(BitbucketWebhookMultibranchTrigger.class.getName());
    private final boolean pullRequestTrigger;
    private final boolean refTrigger;
    private final int version;

    @DataBoundConstructor
    public BitbucketWebhookMultibranchTrigger(boolean pullRequestTrigger, boolean refTrigger) {
        this.refTrigger = refTrigger;
        this.pullRequestTrigger = pullRequestTrigger;
        this.version = 1;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public boolean isApplicableForEventType(AbstractWebhookEvent event) {
        if (event instanceof PullRequestWebhookEvent) {
            if (this.isPullRequestTrigger()) {
                return event instanceof PullRequestOpenedWebhookEvent || event instanceof PullRequestFromRefUpdatedWebhookEvent;
            }
        } else if (event instanceof RefsChangedWebhookEvent) {
            return this.isRefTrigger();
        }
        return false;
    }

    public boolean isPullRequestTrigger() {
        return this.pullRequestTrigger;
    }

    public boolean isRefTrigger() {
        if (this.version < 1) {
            return true;
        }
        return this.refTrigger;
    }

    @Symbol(value={"BitbucketWebhookMultibranchTrigger"})
    @Extension
    public static class DescriptorImpl
    extends TriggerDescriptor {
        @Inject
        private BitbucketPluginConfiguration bitbucketPluginConfiguration;
        @Inject
        private RetryingWebhookHandler retryingWebhookHandler;

        public DescriptorImpl() {
        }

        @VisibleForTesting
        DescriptorImpl(RetryingWebhookHandler webhookHandler, BitbucketPluginConfiguration bitbucketPluginConfiguration) {
            this.retryingWebhookHandler = webhookHandler;
            this.bitbucketPluginConfiguration = bitbucketPluginConfiguration;
        }

        public String getDisplayName() {
            return Messages.BitbucketWebhookMultibranchTrigger_displayname();
        }

        public boolean isApplicable(Item item) {
            return item instanceof MultiBranchProject;
        }
    }
}

