/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.scm.filesystem;

import com.atlassian.bitbucket.jenkins.internal.client.BitbucketFilePathClient;
import com.atlassian.bitbucket.jenkins.internal.client.exception.NotFoundException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Optional;
import javax.annotation.Nullable;
import jenkins.scm.api.SCMFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class BitbucketSCMFile
extends SCMFile {
    private final BitbucketFilePathClient client;
    private final String ref;

    public BitbucketSCMFile(BitbucketFilePathClient client, @Nullable String ref) {
        this.client = client;
        this.ref = ref;
        this.type(SCMFile.Type.DIRECTORY);
    }

    public BitbucketSCMFile(BitbucketSCMFile parent, String name, SCMFile.Type type) {
        super((SCMFile)parent, name);
        this.client = parent.client;
        this.ref = parent.ref;
        this.type(type);
    }

    protected SCMFile newChild(String name, boolean assumeIsDirectory) {
        return new BitbucketSCMFile(this, name, assumeIsDirectory ? SCMFile.Type.DIRECTORY : SCMFile.Type.REGULAR_FILE);
    }

    public Iterable<SCMFile> children() throws IOException, InterruptedException {
        if (this.isDirectory()) {
            return this.client.getDirectoryContent(this);
        }
        throw new IOException("Cannot get content- only valid with DIRECTORY type files");
    }

    public String getFilePath() {
        StringBuilder path = new StringBuilder(this.getName());
        for (SCMFile nextParent = this.parent(); nextParent != null && !StringUtils.isEmpty((CharSequence)nextParent.getName()); nextParent = nextParent.parent()) {
            path.insert(0, nextParent.getName() + '/');
        }
        return path.toString();
    }

    public long lastModified() {
        return 0L;
    }

    protected SCMFile.Type type() throws IOException, InterruptedException {
        return this.getType();
    }

    public InputStream content() throws IOException, InterruptedException {
        if (this.isFile()) {
            try {
                return IOUtils.toInputStream((String)this.client.getFileContent(this), (Charset)Charset.defaultCharset());
            }
            catch (NotFoundException nfe) {
                throw new FileNotFoundException("No file present at location " + this.getFilePath());
            }
        }
        throw new IOException("Cannot get content- only valid with REGULAR_FILE type files");
    }

    public Optional<String> getRef() {
        return Optional.ofNullable(this.ref);
    }
}

