/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.scm;

import com.atlassian.bitbucket.jenkins.internal.client.BitbucketClientFactoryProvider;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketSearchHelper;
import com.atlassian.bitbucket.jenkins.internal.client.exception.BitbucketClientException;
import com.atlassian.bitbucket.jenkins.internal.config.BitbucketPluginConfiguration;
import com.atlassian.bitbucket.jenkins.internal.credentials.BitbucketCredentials;
import com.atlassian.bitbucket.jenkins.internal.credentials.CredentialUtils;
import com.atlassian.bitbucket.jenkins.internal.credentials.JenkinsToBitbucketCredentials;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketProject;
import com.atlassian.bitbucket.jenkins.internal.provider.JenkinsProvider;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketMirrorHandler;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketScmFormFill;
import com.atlassian.bitbucket.jenkins.internal.scm.MirrorFetchRequest;
import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import hudson.model.Item;
import hudson.plugins.git.GitTool;
import hudson.plugins.git.extensions.GitSCMExtensionDescriptor;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;

@Singleton
public class BitbucketScmFormFillDelegate
implements BitbucketScmFormFill {
    private static final Logger LOGGER = Logger.getLogger(BitbucketScmFormFillDelegate.class.getName());
    private final BitbucketClientFactoryProvider bitbucketClientFactoryProvider;
    private final BitbucketPluginConfiguration bitbucketPluginConfiguration;
    private final JenkinsToBitbucketCredentials jenkinsToBitbucketCredentials;
    private final JenkinsProvider jenkinsProvider;

    @Inject
    public BitbucketScmFormFillDelegate(BitbucketClientFactoryProvider bitbucketClientFactoryProvider, BitbucketPluginConfiguration bitbucketPluginConfiguration, JenkinsToBitbucketCredentials jenkinsToBitbucketCredentials, JenkinsProvider jenkinsProvider) {
        this.bitbucketClientFactoryProvider = Objects.requireNonNull(bitbucketClientFactoryProvider, "bitbucketClientFactoryProvider");
        this.bitbucketPluginConfiguration = Objects.requireNonNull(bitbucketPluginConfiguration, "bitbucketPluginConfiguration");
        this.jenkinsToBitbucketCredentials = Objects.requireNonNull(jenkinsToBitbucketCredentials, "jenkinsToBitbucketCredentils");
        this.jenkinsProvider = Objects.requireNonNull(jenkinsProvider, "jenkinsProvider");
    }

    @Override
    public ListBoxModel doFillCredentialsIdItems(@Nullable Item context, String baseUrl, String credentialsId) {
        this.checkPermissions(context);
        return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM, context, StringCredentials.class, URIRequirementBuilder.fromUri((String)baseUrl).build(), CredentialsMatchers.always()).includeMatchingAs(ACL.SYSTEM, context, StandardUsernamePasswordCredentials.class, URIRequirementBuilder.fromUri((String)baseUrl).build(), CredentialsMatchers.always());
    }

    @Override
    public ListBoxModel doFillSshCredentialsIdItems(@Nullable Item context, String baseUrl, String sshCredentialsId) {
        this.checkPermissions(context);
        return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM, context, BasicSSHUserPrivateKey.class, URIRequirementBuilder.fromUri((String)baseUrl).build(), CredentialsMatchers.always());
    }

    @Override
    public HttpResponse doFillProjectNameItems(@Nullable Item context, String serverId, String credentialsId, String projectName) {
        this.checkPermissions(context);
        if (StringUtils.isBlank((CharSequence)serverId)) {
            return HttpResponses.errorWithoutStack((int)400, (String)"A Bitbucket Server serverId must be provided");
        }
        if (StringUtils.stripToEmpty((String)projectName).length() < 2) {
            return HttpResponses.errorWithoutStack((int)400, (String)"The project name must be at least 2 characters long");
        }
        Optional<Credentials> providedCredentials = CredentialUtils.getCredentials(credentialsId, context);
        if (!StringUtils.isBlank((CharSequence)credentialsId) && !providedCredentials.isPresent()) {
            return HttpResponses.errorWithoutStack((int)400, (String)"No credentials exist for the provided credentialsId");
        }
        return this.bitbucketPluginConfiguration.getServerById(serverId).map(serverConf -> {
            try {
                BitbucketCredentials credentials = this.jenkinsToBitbucketCredentials.toBitbucketCredentials((Credentials)providedCredentials.orElse(null));
                Collection<BitbucketProject> projects = BitbucketSearchHelper.findProjects(projectName, this.bitbucketClientFactoryProvider.getClient(serverConf.getBaseUrl(), credentials));
                return hudson.util.HttpResponses.okJSON((JSONArray)JSONArray.fromObject(projects));
            }
            catch (BitbucketClientException e) {
                LOGGER.info(e.getMessage());
                return HttpResponses.errorWithoutStack((int)500, (String)("An error occurred in Bitbucket: " + e.getMessage()));
            }
        }).orElseGet(() -> HttpResponses.errorWithoutStack((int)400, (String)"The provided Bitbucket Server serverId does not exist"));
    }

    @Override
    public HttpResponse doFillRepositoryNameItems(@Nullable Item context, String serverId, String credentialsId, String projectName, String repositoryName) {
        this.checkPermissions(context);
        if (StringUtils.isBlank((CharSequence)serverId)) {
            return HttpResponses.errorWithoutStack((int)400, (String)"A Bitbucket Server serverId must be provided");
        }
        if (StringUtils.stripToEmpty((String)repositoryName).length() < 2) {
            return HttpResponses.errorWithoutStack((int)400, (String)"The repository name must be at least 2 characters long");
        }
        if (StringUtils.isBlank((CharSequence)projectName)) {
            return HttpResponses.errorWithoutStack((int)400, (String)"The projectName must be present");
        }
        Optional<Credentials> providedCredentials = CredentialUtils.getCredentials(credentialsId, context);
        if (!StringUtils.isBlank((CharSequence)credentialsId) && !providedCredentials.isPresent()) {
            return HttpResponses.errorWithoutStack((int)400, (String)"No credentials exist for the provided credentialsId");
        }
        return this.bitbucketPluginConfiguration.getServerById(serverId).map(serverConf -> {
            BitbucketCredentials credentials = this.jenkinsToBitbucketCredentials.toBitbucketCredentials((Credentials)providedCredentials.orElse(null));
            try {
                Collection repositories = BitbucketSearchHelper.findRepositories(repositoryName, projectName, this.bitbucketClientFactoryProvider.getClient(serverConf.getBaseUrl(), credentials)).stream().filter(repository -> repository.getProject().getName().equals(projectName)).collect(Collectors.toList());
                return hudson.util.HttpResponses.okJSON((JSONArray)JSONArray.fromObject((Object)repositories));
            }
            catch (BitbucketClientException e) {
                LOGGER.info(e.getMessage());
                return HttpResponses.errorWithoutStack((int)500, (String)("An error occurred in Bitbucket: " + e.getMessage()));
            }
        }).orElseGet(() -> HttpResponses.errorWithoutStack((int)400, (String)"The provided Bitbucket Server serverId does not exist"));
    }

    @Override
    public ListBoxModel doFillServerIdItems(@Nullable Item context, String serverId) {
        this.checkPermissions(context);
        StandardListBoxModel model = this.bitbucketPluginConfiguration.getServerList().stream().filter(server -> server.getId().equals(serverId) || server.validate().kind == FormValidation.Kind.OK).map(server -> new ListBoxModel.Option(server.getServerName(), server.getId(), server.getId().equals(serverId))).collect(Collectors.toCollection(StandardListBoxModel::new));
        if (model.isEmpty() || model.stream().noneMatch(server -> server.value.equals(serverId))) {
            model.includeEmptyValue();
        }
        return model;
    }

    @Override
    public ListBoxModel doFillMirrorNameItems(@Nullable Item context, String serverId, String credentialsId, String projectName, String repositoryName, String mirrorName) {
        this.checkPermissions(context);
        BitbucketMirrorHandler bitbucketMirrorHandler = this.createMirrorHandlerUsingRepoSearch();
        return this.bitbucketPluginConfiguration.getServerById(serverId).map(serverConfiguration -> bitbucketMirrorHandler.fetchAsListBox(new MirrorFetchRequest(serverConfiguration.getBaseUrl(), credentialsId, serverConfiguration.getGlobalCredentialsProvider("Bitbucket SCM Fill Mirror list"), projectName, repositoryName, mirrorName))).orElseGet(() -> bitbucketMirrorHandler.getDefaultListBox());
    }

    @Override
    public List<GitSCMExtensionDescriptor> getExtensionDescriptors() {
        return Collections.emptyList();
    }

    @Override
    public List<GitTool> getGitTools() {
        return Collections.emptyList();
    }

    @Override
    public boolean getShowGitToolOptions() {
        return false;
    }

    private void checkPermissions(@Nullable Item context) {
        if (context != null) {
            context.checkPermission(Item.EXTENDED_READ);
        } else {
            this.jenkinsProvider.get().checkPermission(Jenkins.ADMINISTER);
        }
    }

    private BitbucketMirrorHandler createMirrorHandlerUsingRepoSearch() {
        return new BitbucketMirrorHandler(this.bitbucketClientFactoryProvider, this.jenkinsToBitbucketCredentials, (client, project, repo) -> BitbucketSearchHelper.getRepositoryByNameOrSlug(project, repo, client));
    }
}

