/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.scm;

import com.atlassian.bitbucket.jenkins.internal.client.BitbucketClientFactoryProvider;
import com.atlassian.bitbucket.jenkins.internal.config.BitbucketPluginConfiguration;
import com.atlassian.bitbucket.jenkins.internal.config.BitbucketServerConfiguration;
import com.atlassian.bitbucket.jenkins.internal.config.BitbucketTokenCredentials;
import com.atlassian.bitbucket.jenkins.internal.credentials.GlobalCredentialsProvider;
import com.atlassian.bitbucket.jenkins.internal.credentials.JenkinsToBitbucketCredentials;
import com.atlassian.bitbucket.jenkins.internal.credentials.JenkinsToBitbucketCredentialsModule;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketNamedLink;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketProject;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketRepository;
import com.atlassian.bitbucket.jenkins.internal.model.RepositoryState;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketMirrorHandler;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCM;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMException;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketScmFormFill;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketScmFormFillDelegate;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketScmFormValidation;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketScmFormValidationDelegate;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketScmHelper;
import com.atlassian.bitbucket.jenkins.internal.scm.CloneProtocol;
import com.atlassian.bitbucket.jenkins.internal.scm.EnrichedBitbucketMirroredRepository;
import com.atlassian.bitbucket.jenkins.internal.scm.MirrorFetchException;
import com.atlassian.bitbucket.jenkins.internal.scm.MirrorFetchRequest;
import com.cloudbees.plugins.credentials.Credentials;
import com.google.inject.Guice;
import com.google.inject.Module;
import hudson.Extension;
import hudson.model.Item;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitTool;
import hudson.plugins.git.extensions.GitSCMExtensionDescriptor;
import hudson.scm.SCM;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.workflow.steps.scm.SCMStep;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class BitbucketSCMStep
extends SCMStep {
    private List<BranchSpec> branches;
    private String cloneUrl;
    private String credentialsId;
    private String sshCredentialsId;
    private String id = UUID.randomUUID().toString();
    private String projectKey;
    private final String projectName;
    private final String repositoryName;
    private String repositorySlug;
    private int repositoryId;
    private String selfLink;
    private final String serverId;
    private String mirrorName;

    @DataBoundConstructor
    public BitbucketSCMStep(String projectName, String repositoryName, String serverId) {
        this.branches = Collections.singletonList(new BranchSpec("**"));
        if (StringUtils.isBlank((CharSequence)serverId)) {
            throw new BitbucketSCMException("Error creating Bitbucket SCM: No server configuration provided");
        }
        this.serverId = serverId;
        if (StringUtils.isBlank((CharSequence)projectName)) {
            throw new BitbucketSCMException("Error creating the Bitbucket SCM: The project name is blank");
        }
        this.projectName = projectName;
        if (StringUtils.isBlank((CharSequence)repositoryName)) {
            throw new BitbucketSCMException("Error creating the Bitbucket SCM: The repository name is blank");
        }
        this.repositoryName = repositoryName;
    }

    @DataBoundSetter
    public void setId(String id) {
        this.id = Objects.requireNonNull(id, "id");
    }

    @DataBoundSetter
    public void setCredentialsId(@Nullable String credentialsId) {
        this.credentialsId = StringUtils.stripToNull((String)credentialsId);
    }

    @DataBoundSetter
    public void setSshCredentialsId(@Nullable String sshCredentialsId) {
        this.sshCredentialsId = StringUtils.stripToNull((String)sshCredentialsId);
    }

    @DataBoundSetter
    public void setMirrorName(@Nullable String mirrorName) {
        this.mirrorName = StringUtils.stripToNull((String)mirrorName);
    }

    @DataBoundSetter
    public void setBranches(List<BranchSpec> branches) {
        this.branches = Objects.requireNonNull(branches, "branches");
    }

    public List<BranchSpec> getBranches() {
        return this.branches;
    }

    public String getCloneUrl() {
        return this.cloneUrl;
    }

    @Nullable
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @Nullable
    public String getSshCredentialsId() {
        return this.sshCredentialsId;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getMirrorName() {
        return this.mirrorName;
    }

    @Nullable
    public String getProjectKey() {
        return this.projectKey;
    }

    public String getProjectName() {
        return !StringUtils.isBlank((CharSequence)this.projectKey) && this.projectKey.startsWith("~") ? this.projectKey : this.projectName;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    @Nullable
    public String getRepositorySlug() {
        return this.repositorySlug;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public String getServerId() {
        return this.serverId;
    }

    public int getRepositoryId() {
        return this.repositoryId;
    }

    protected SCM createSCM() {
        BitbucketRepository repository;
        DescriptorImpl descriptor = (DescriptorImpl)this.getDescriptor();
        Optional mayBeServerConf = descriptor.getConfiguration(this.serverId);
        if (!mayBeServerConf.isPresent()) {
            throw new BitbucketSCMException("Error creating the Bitbucket SCM: No Bitbucket Server configuration for serverId " + this.serverId);
        }
        BitbucketServerConfiguration serverConfiguration = (BitbucketServerConfiguration)((Object)mayBeServerConf.get());
        GlobalCredentialsProvider globalCredentialsProvider = serverConfiguration.getGlobalCredentialsProvider(String.format("Bitbucket SCM Step: Query Bitbucket for project [%s] repo [%s] mirror [%s]", this.projectName, this.repositoryName, this.mirrorName));
        BitbucketScmHelper scmHelper = descriptor.getBitbucketScmHelper(serverConfiguration.getBaseUrl(), globalCredentialsProvider.getGlobalAdminCredentials().orElse(null));
        if (!StringUtils.isBlank((CharSequence)this.mirrorName)) {
            try {
                EnrichedBitbucketMirroredRepository mirroredRepository = descriptor.createMirrorHandler(scmHelper).fetchRepository(new MirrorFetchRequest(serverConfiguration.getBaseUrl(), this.credentialsId, globalCredentialsProvider, this.projectName, this.repositoryName, this.mirrorName));
                repository = mirroredRepository.getRepository();
                this.cloneUrl = this.getCloneUrl(mirroredRepository.getMirroringDetails().getCloneUrls());
            }
            catch (MirrorFetchException ex) {
                throw new BitbucketSCMException("Error creating the Bitbucket SCM: " + ex.getMessage());
            }
        } else {
            repository = scmHelper.getRepository(this.projectName, this.repositoryName);
            this.cloneUrl = this.getCloneUrl(repository.getCloneUrls());
        }
        this.projectKey = repository.getProject().getKey();
        this.repositorySlug = repository.getSlug();
        this.selfLink = repository.getSelfLink();
        this.repositoryId = repository.getId();
        BitbucketProject bitbucketProject = new BitbucketProject(this.projectKey, null, this.projectName);
        List<BitbucketNamedLink> cloneUrls = Collections.singletonList(new BitbucketNamedLink(this.getCloneProtocol().name, this.cloneUrl));
        BitbucketRepository bitbucketRepository = new BitbucketRepository(this.repositoryId, this.repositoryName, bitbucketProject, this.repositorySlug, RepositoryState.AVAILABLE, cloneUrls, this.selfLink);
        return new BitbucketSCM(this.id, this.branches, this.credentialsId, this.sshCredentialsId, null, null, this.serverId, bitbucketRepository);
    }

    private String getCloneUrl(List<BitbucketNamedLink> cloneUrls) {
        return cloneUrls.stream().filter(link -> this.getCloneProtocol().name.equals(link.getName())).findFirst().map(BitbucketNamedLink::getHref).orElse("");
    }

    private CloneProtocol getCloneProtocol() {
        return StringUtils.isBlank((CharSequence)this.sshCredentialsId) ? CloneProtocol.HTTP : CloneProtocol.SSH;
    }

    @Symbol(value={"BitbucketSCMStep"})
    @Extension
    public static final class DescriptorImpl
    extends SCMStep.SCMStepDescriptor
    implements BitbucketScmFormValidation,
    BitbucketScmFormFill {
        @Inject
        private BitbucketClientFactoryProvider bitbucketClientFactoryProvider;
        @Inject
        private BitbucketPluginConfiguration bitbucketPluginConfiguration;
        @Inject
        private BitbucketScmFormFillDelegate formFill;
        @Inject
        private BitbucketScmFormValidationDelegate formValidation;
        private transient JenkinsToBitbucketCredentials jenkinsToBitbucketCredentials;

        @Override
        @POST
        public FormValidation doCheckCredentialsId(@AncestorInPath Item context, @QueryParameter String credentialsId) {
            return this.formValidation.doCheckCredentialsId(context, credentialsId);
        }

        @Override
        public FormValidation doCheckSshCredentialsId(@AncestorInPath Item context, @QueryParameter String sshCredentialsId) {
            return this.formValidation.doCheckSshCredentialsId(context, sshCredentialsId);
        }

        @Override
        @POST
        public FormValidation doCheckProjectName(@AncestorInPath Item context, @QueryParameter String serverId, @QueryParameter String credentialsId, @QueryParameter String projectName) {
            return this.formValidation.doCheckProjectName(context, serverId, credentialsId, projectName);
        }

        @Override
        @POST
        public FormValidation doCheckRepositoryName(@AncestorInPath Item context, @QueryParameter String serverId, @QueryParameter String credentialsId, @QueryParameter String projectName, @QueryParameter String repositoryName) {
            return this.formValidation.doCheckRepositoryName(context, serverId, credentialsId, projectName, repositoryName);
        }

        @Override
        @POST
        public FormValidation doCheckServerId(@AncestorInPath Item context, @QueryParameter String serverId) {
            return this.formValidation.doCheckServerId(context, serverId);
        }

        @Override
        public FormValidation doTestConnection(@AncestorInPath Item context, @QueryParameter String serverId, @QueryParameter String credentialsId, @QueryParameter String projectName, @QueryParameter String repositoryName, @QueryParameter String mirrorName) {
            return this.formValidation.doTestConnection(context, serverId, credentialsId, projectName, repositoryName, mirrorName);
        }

        @Override
        @POST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item context, @QueryParameter String baseUrl, @QueryParameter String credentialsId) {
            return this.formFill.doFillCredentialsIdItems(context, baseUrl, credentialsId);
        }

        @Override
        @POST
        public ListBoxModel doFillSshCredentialsIdItems(@AncestorInPath Item context, @QueryParameter String baseUrl, @QueryParameter String sshCredentialsId) {
            return this.formFill.doFillSshCredentialsIdItems(context, baseUrl, sshCredentialsId);
        }

        @Override
        @POST
        public HttpResponse doFillProjectNameItems(@AncestorInPath Item context, @QueryParameter String serverId, @QueryParameter String credentialsId, @QueryParameter String projectName) {
            return this.formFill.doFillProjectNameItems(context, serverId, credentialsId, projectName);
        }

        @Override
        @POST
        public HttpResponse doFillRepositoryNameItems(@AncestorInPath Item context, @QueryParameter String serverId, @QueryParameter String credentialsId, @QueryParameter String projectName, @QueryParameter String repositoryName) {
            return this.formFill.doFillRepositoryNameItems(context, serverId, credentialsId, projectName, repositoryName);
        }

        @Override
        @POST
        public ListBoxModel doFillServerIdItems(@AncestorInPath Item context, @QueryParameter String serverId) {
            return this.formFill.doFillServerIdItems(context, serverId);
        }

        @Override
        public ListBoxModel doFillMirrorNameItems(@AncestorInPath Item context, @QueryParameter String serverId, @QueryParameter String credentialsId, @QueryParameter String projectName, @QueryParameter String repositoryName, @QueryParameter String mirrorName) {
            return this.formFill.doFillMirrorNameItems(context, serverId, credentialsId, projectName, repositoryName, mirrorName);
        }

        @Override
        public List<GitSCMExtensionDescriptor> getExtensionDescriptors() {
            return Collections.emptyList();
        }

        public String getFunctionName() {
            return "bbs_checkout";
        }

        @Override
        public List<GitTool> getGitTools() {
            return Collections.emptyList();
        }

        @Override
        public boolean getShowGitToolOptions() {
            return false;
        }

        @Inject
        public void setJenkinsToBitbucketCredentials(JenkinsToBitbucketCredentials jenkinsToBitbucketCredentials) {
            this.jenkinsToBitbucketCredentials = jenkinsToBitbucketCredentials;
        }

        private BitbucketMirrorHandler createMirrorHandler(BitbucketScmHelper helper) {
            this.injectJenkinsToBitbucketCredentials();
            return new BitbucketMirrorHandler(this.bitbucketClientFactoryProvider, this.jenkinsToBitbucketCredentials, (client, project, repo) -> helper.getRepository(project, repo));
        }

        BitbucketScmHelper getBitbucketScmHelper(String bitbucketUrl, @Nullable BitbucketTokenCredentials tokenCredentials) {
            return new BitbucketScmHelper(bitbucketUrl, this.bitbucketClientFactoryProvider, this.jenkinsToBitbucketCredentials.toBitbucketCredentials((Credentials)tokenCredentials));
        }

        private Optional<BitbucketServerConfiguration> getConfiguration(@Nullable String serverId) {
            return this.bitbucketPluginConfiguration.getServerById(serverId);
        }

        private void injectJenkinsToBitbucketCredentials() {
            if (this.jenkinsToBitbucketCredentials == null) {
                Guice.createInjector((Module[])new Module[]{new JenkinsToBitbucketCredentialsModule()}).injectMembers((Object)this);
            }
        }
    }
}

