/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.model.deployment;

import com.atlassian.bitbucket.jenkins.internal.model.deployment.BitbucketDeploymentEnvironmentType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckForNull;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BitbucketDeploymentEnvironment
implements Serializable {
    private static final String DISPLAY_NAME = "displayName";
    private static final String KEY = "key";
    private static final long serialVersionUID = 1L;
    private static final String TYPE = "type";
    private static final String URL = "url";
    private final String key;
    private final String name;
    private final BitbucketDeploymentEnvironmentType type;
    private final URI url;

    @JsonCreator
    public BitbucketDeploymentEnvironment(@JsonProperty(value="key") String key, @JsonProperty(value="displayName") String name, @CheckForNull @JsonProperty(value="type") BitbucketDeploymentEnvironmentType type, @CheckForNull @JsonProperty(value="url") URI url) {
        this.key = key;
        this.name = name;
        this.type = type;
        this.url = url;
    }

    public BitbucketDeploymentEnvironment(String key, String name) {
        this(key, name, null, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BitbucketDeploymentEnvironment that = (BitbucketDeploymentEnvironment)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.name, that.name) && Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.url, that.url);
    }

    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    @JsonProperty(value="displayName")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="type")
    @CheckForNull
    public BitbucketDeploymentEnvironmentType getType() {
        return this.type;
    }

    @JsonProperty(value="url")
    @CheckForNull
    public URI getUrl() {
        return this.url;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.key, this.name, this.type, this.url});
    }

    public String toString() {
        return "BitbucketDeploymentEnvironment{key='" + this.key + '\'' + ", name='" + this.name + '\'' + ", type='" + (Object)((Object)this.type) + '\'' + ", url='" + this.url + '\'' + '}';
    }
}

