/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.jenkins.oauth.consumer;

import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.consumer.Consumer;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.consumer.ServiceProviderConsumerStore;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.token.ServiceProviderTokenStore;
import com.atlassian.bitbucket.jenkins.internal.jenkins.oauth.consumer.Messages;
import com.atlassian.bitbucket.jenkins.internal.jenkins.oauth.consumer.OAuthConsumerEntry;
import com.atlassian.bitbucket.jenkins.internal.provider.DefaultJenkinsProvider;
import com.atlassian.bitbucket.jenkins.internal.provider.JenkinsProvider;
import com.google.common.annotations.VisibleForTesting;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Action;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.servlet.ServletException;
import jenkins.model.ModelObjectWithContextMenu;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class OAuthConsumerUpdateAction
extends AbstractDescribableImpl<OAuthConsumerUpdateAction>
implements Action,
ModelObjectWithContextMenu {
    private final String consumerKey;
    private final ServiceProviderConsumerStore consumerStore;
    private final JenkinsProvider jenkinsProvider;
    private final ServiceProviderTokenStore tokenStore;

    @VisibleForTesting
    OAuthConsumerUpdateAction(String consumerKey, ServiceProviderConsumerStore consumerStore, ServiceProviderTokenStore tokenStore, JenkinsProvider jenkinsProvider) {
        this.consumerKey = Objects.requireNonNull(consumerKey, "consumerKey");
        this.consumerStore = Objects.requireNonNull(consumerStore, "consumerStore");
        this.jenkinsProvider = Objects.requireNonNull(jenkinsProvider, "jenkinsProvider");
        this.tokenStore = Objects.requireNonNull(tokenStore, "tokenStore");
    }

    public OAuthConsumerUpdateAction(String consumerKey, ServiceProviderConsumerStore consumerStore, ServiceProviderTokenStore tokenStore) {
        this(consumerKey, consumerStore, tokenStore, new DefaultJenkinsProvider());
    }

    public ModelObjectWithContextMenu.ContextMenu doContextMenu(StaplerRequest request, StaplerResponse response) throws Exception {
        return new ModelObjectWithContextMenu.ContextMenu().from((ModelObjectWithContextMenu)this, request, response);
    }

    @RequirePOST
    public HttpResponse doPerformDelete(StaplerRequest req) {
        this.tokenStore.removeByConsumer(this.consumerKey);
        this.consumerStore.delete(this.consumerKey);
        return HttpResponses.redirectViaContextPath((String)"bbs-oauth");
    }

    @RequirePOST
    public HttpResponse doPerformUpdate(StaplerRequest req) throws ServletException, URISyntaxException {
        Consumer consumer = this.getConsumerDescriptor().getConsumerFromSubmittedForm(req);
        this.consumerStore.update(consumer);
        return HttpResponses.redirectViaContextPath((String)"bbs-oauth");
    }

    @Nullable
    public OAuthConsumerEntry.OAuthConsumerEntryDescriptor getConsumerDescriptor() {
        OAuthConsumerEntry entry = this.getConsumerEntry();
        if (entry != null) {
            return entry.getDescriptor();
        }
        return null;
    }

    @CheckForNull
    public OAuthConsumerEntry getConsumerEntry() {
        return this.consumerStore.get(this.consumerKey).map(OAuthConsumerEntry::getOAuthConsumerForUpdate).orElse(null);
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public String getDisplayName() {
        return Messages.bitbucket_oauth_consumer_admin_update_description();
    }

    public String getIconFileName() {
        return "setting.png";
    }

    public String getJenkinsBaseUrl() {
        return this.jenkinsProvider.get().getRootUrl();
    }

    public String getRequestTokenUrl() throws URISyntaxException {
        return new URI(this.jenkinsProvider.get().getRootUrl()).getPath() + "bitbucket/oauth/request-token";
    }

    public String getAccessTokenUrl() throws URISyntaxException {
        return new URI(this.jenkinsProvider.get().getRootUrl()).getPath() + "bitbucket/oauth/access-token";
    }

    public String getAuthorizeUrl() throws URISyntaxException {
        return new URI(this.jenkinsProvider.get().getRootUrl()).getPath() + "bbs-oauth/authorize";
    }

    public String getUrlName() {
        return this.consumerKey;
    }
}

