/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.jenkins.oauth.consumer;

import com.atlassian.bitbucket.jenkins.internal.annotations.NotUpgradeSensitive;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.consumer.Consumer;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.consumer.ServiceProviderConsumerStore;
import com.atlassian.bitbucket.jenkins.internal.jenkins.oauth.consumer.Messages;
import com.atlassian.bitbucket.jenkins.internal.jenkins.oauth.consumer.OAuthConsumerEntry;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Action;
import hudson.model.Descriptor;
import java.net.URISyntaxException;
import java.util.Objects;
import javax.servlet.ServletException;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;

@NotUpgradeSensitive
public class OAuthConsumerCreateAction
extends AbstractDescribableImpl<OAuthConsumerCreateAction>
implements Action {
    private final ServiceProviderConsumerStore store;

    public OAuthConsumerCreateAction(ServiceProviderConsumerStore store) {
        this.store = Objects.requireNonNull(store, "store");
    }

    @RequirePOST
    public HttpResponse doPerformCreate(StaplerRequest req) throws ServletException, URISyntaxException {
        Consumer consumer = this.getConsumerDescriptor().getConsumerFromSubmittedForm(req);
        this.store.add(consumer);
        return HttpResponses.redirectViaContextPath((String)("bbs-oauth/consumer/" + consumer.getKey() + "/applinkinfo"));
    }

    public OAuthConsumerEntry.OAuthConsumerEntryDescriptor getConsumerDescriptor() {
        return OAuthConsumerEntry.getOAuthConsumerForAdd().getDescriptor();
    }

    public String getDisplayName() {
        return Messages.bitbucket_oauth_consumer_admin_create_description();
    }

    public String getIconFileName() {
        return "setting.png";
    }

    public String getUrlName() {
        return "new";
    }

    @Extension
    @Symbol(value={"oauth-consumer-create"})
    public static class DescriptorImpl
    extends Descriptor<OAuthConsumerCreateAction> {
    }
}

