/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.config;

import com.atlassian.bitbucket.jenkins.internal.config.BitbucketTokenCredentials;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import hudson.Extension;
import hudson.util.Secret;
import javax.annotation.CheckForNull;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.jenkins.ui.icon.IconType;
import org.kohsuke.stapler.DataBoundConstructor;

public class BitbucketTokenCredentialsImpl
extends BaseStandardCredentials
implements BitbucketTokenCredentials {
    private static final long serialVersionUID = 1L;
    private final Secret secret;

    @DataBoundConstructor
    public BitbucketTokenCredentialsImpl(@CheckForNull String id, @CheckForNull String description, Secret secret) {
        super(CredentialsScope.SYSTEM, id, description);
        this.secret = secret;
    }

    @Override
    public Secret getSecret() {
        return this.secret;
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        public String getDisplayName() {
            return "Bitbucket personal access token";
        }

        public String getIconClassName() {
            return "icon-bitbucket-credentials";
        }

        static {
            IconSet.icons.addIcon(new Icon("icon-bitbucket-credentials icon-sm", "atlassian-bitbucket-server-integration/images/16x16/credentials.png", "width: 16px; height: 16px;", IconType.PLUGIN));
            IconSet.icons.addIcon(new Icon("icon-bitbucket-credentials icon-md", "atlassian-bitbucket-server-integration/images/24x24/credentials.png", "width: 24px; height: 24px;", IconType.PLUGIN));
            IconSet.icons.addIcon(new Icon("icon-bitbucket-credentials icon-lg", "atlassian-bitbucket-server-integration/images/32x32/credentials.png", "width: 32px; height: 32px;", IconType.PLUGIN));
            IconSet.icons.addIcon(new Icon("icon-bitbucket-credentials icon-xlg", "atlassian-bitbucket-server-integration/images/48x48/credentials.png", "width: 48px; height: 48px;", IconType.PLUGIN));
        }
    }
}

