/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.client.paging;

import com.atlassian.bitbucket.jenkins.internal.client.paging.NextPageFetcher;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketPage;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class BitbucketPageStreamUtil {
    public static <T> Stream<BitbucketPage<T>> toStream(BitbucketPage<T> firstPage, NextPageFetcher<T> nextPageFetcher) {
        return StreamSupport.stream(BitbucketPageStreamUtil.pageIterable(firstPage, nextPageFetcher).spliterator(), false);
    }

    private static <T> Iterable<BitbucketPage<T>> pageIterable(BitbucketPage<T> firstPage, NextPageFetcher<T> nextPageFetcher) {
        return () -> new PageIterator(nextPageFetcher, firstPage);
    }

    private static class PageIterator<T>
    implements Iterator<BitbucketPage<T>> {
        private final NextPageFetcher<T> nextPageFetcher;
        private BitbucketPage<T> currentPage;

        PageIterator(NextPageFetcher<T> nextPageFetcher, BitbucketPage<T> firstPage) {
            this.nextPageFetcher = nextPageFetcher;
            this.currentPage = firstPage;
        }

        @Override
        public boolean hasNext() {
            return this.currentPage != null;
        }

        @Override
        public BitbucketPage<T> next() {
            BitbucketPage<T> result;
            if (this.currentPage == null) {
                throw new NoSuchElementException("The current page is null");
            }
            if (this.currentPage.isLastPage()) {
                result = this.currentPage;
                this.currentPage = null;
            } else {
                result = this.currentPage;
                this.currentPage = this.nextPageFetcher.next(this.currentPage);
            }
            return result;
        }
    }
}

