/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.client;

import com.atlassian.bitbucket.jenkins.internal.client.BitbucketBuildStatusClient;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketRequestExecutor;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketBuildStatus;
import com.atlassian.bitbucket.jenkins.internal.provider.DefaultInstanceKeyPairProvider;
import com.atlassian.bitbucket.jenkins.internal.provider.InstanceKeyPairProvider;
import com.google.common.annotations.VisibleForTesting;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jenkinsci.plugins.displayurlapi.DisplayURLProvider;

public class ModernBitbucketBuildStatusClientImpl
implements BitbucketBuildStatusClient {
    private static final String BASE_URL_HEADER_ID = "base-url";
    private static final String BUILD_STATUS_SIGNATURE_ALGORITHM_ID = "BBS-Signature-Algorithm";
    private static final String BUILD_STATUS_SIGNATURE_ID = "BBS-Signature";
    private static final String BUILD_STATUS_VERSION = "1.0";
    private static final String SIGNING_ALGORITHM = "SHA256";
    private static final Logger LOGGER = Logger.getLogger((String)ModernBitbucketBuildStatusClientImpl.class.getName());
    private final BitbucketRequestExecutor bitbucketRequestExecutor;
    private final DisplayURLProvider displayURLProvider;
    private final InstanceKeyPairProvider instanceKeyPairProvider;
    private final String projectKey;
    private final String repoSlug;
    private final String revisionSha;

    @VisibleForTesting
    ModernBitbucketBuildStatusClientImpl(BitbucketRequestExecutor bitbucketRequestExecutor, String projectKey, String repoSlug, String revisionSha, InstanceKeyPairProvider instanceKeyPairProvider, DisplayURLProvider displayURLProvider) {
        this.bitbucketRequestExecutor = Objects.requireNonNull(bitbucketRequestExecutor, "bitbucketRequestExecutor");
        this.instanceKeyPairProvider = Objects.requireNonNull(instanceKeyPairProvider, "instanceIdentityProvider");
        this.revisionSha = Objects.requireNonNull(StringUtils.stripToNull((String)revisionSha), "revisionSha");
        this.projectKey = Objects.requireNonNull(StringUtils.stripToNull((String)projectKey), "projectKey");
        this.repoSlug = Objects.requireNonNull(StringUtils.stripToNull((String)repoSlug), "repoSlug");
        this.displayURLProvider = Objects.requireNonNull(displayURLProvider, "displayURLProvider");
    }

    ModernBitbucketBuildStatusClientImpl(BitbucketRequestExecutor bitbucketRequestExecutor, String projectKey, String repoSlug, String revisionSha) {
        this(bitbucketRequestExecutor, projectKey, repoSlug, revisionSha, new DefaultInstanceKeyPairProvider(), DisplayURLProvider.get());
    }

    @Override
    public void post(BitbucketBuildStatus buildStatus) {
        HttpUrl url = this.bitbucketRequestExecutor.getBaseUrl().newBuilder().addPathSegment("rest").addPathSegment("api").addPathSegment(BUILD_STATUS_VERSION).addPathSegment("projects").addPathSegment(this.projectKey).addPathSegment("repos").addPathSegment(this.repoSlug).addPathSegment("commits").addPathSegment(this.revisionSha).addPathSegment("builds").build();
        this.bitbucketRequestExecutor.makePostRequest(url, buildStatus, this.generateHeaders(buildStatus));
    }

    private Headers generateHeaders(BitbucketBuildStatus buildStatus) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(BASE_URL_HEADER_ID, this.displayURLProvider.getRoot());
        RSAPrivateKey key = this.instanceKeyPairProvider.getPrivate();
        String algorithm = "SHA256with" + key.getAlgorithm();
        try {
            Signature sig = Signature.getInstance(algorithm);
            sig.initSign(key);
            sig.update(buildStatus.getKey().getBytes(StandardCharsets.UTF_8));
            if (buildStatus.getRef() != null) {
                sig.update(buildStatus.getRef().getBytes(StandardCharsets.UTF_8));
            }
            sig.update(buildStatus.getState().getBytes(StandardCharsets.UTF_8));
            sig.update(buildStatus.getUrl().getBytes(StandardCharsets.UTF_8));
            headers.put(BUILD_STATUS_SIGNATURE_ID, Base64.getEncoder().encodeToString(sig.sign()));
            headers.put(BUILD_STATUS_SIGNATURE_ALGORITHM_ID, algorithm);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            LOGGER.warn((Object)"Error signing build status, continuing without signature:", (Throwable)e);
            return Headers.of(Collections.emptyMap());
        }
        return Headers.of(headers);
    }
}

