/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.client;

import com.atlassian.bitbucket.jenkins.internal.client.BitbucketAuthenticatedUserClient;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketAuthenticatedUserClientImpl;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketCapabilitiesClient;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketCapabilitiesClientImpl;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketClientFactory;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketMirrorClient;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketMirrorClientImpl;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketProjectClient;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketProjectClientImpl;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketRequestExecutor;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketSearchClient;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketSearchClientImpl;
import com.atlassian.bitbucket.jenkins.internal.client.HttpRequestExecutor;
import com.atlassian.bitbucket.jenkins.internal.client.supply.BitbucketCapabilitiesSupplier;
import com.atlassian.bitbucket.jenkins.internal.credentials.BitbucketCredentials;
import com.fasterxml.jackson.databind.ObjectMapper;

public class BitbucketClientFactoryImpl
implements BitbucketClientFactory {
    private final BitbucketRequestExecutor bitbucketRequestExecutor;
    private final BitbucketCapabilitiesSupplier capabilitiesSupplier;

    BitbucketClientFactoryImpl(String serverUrl, BitbucketCredentials credentials, ObjectMapper objectMapper, HttpRequestExecutor httpRequestExecutor) {
        this.bitbucketRequestExecutor = new BitbucketRequestExecutor(serverUrl, httpRequestExecutor, objectMapper, credentials);
        this.capabilitiesSupplier = new BitbucketCapabilitiesSupplier(this.bitbucketRequestExecutor);
    }

    @Override
    public BitbucketAuthenticatedUserClient getAuthenticatedUserClient() {
        return new BitbucketAuthenticatedUserClientImpl(this.bitbucketRequestExecutor);
    }

    @Override
    public BitbucketCapabilitiesClient getCapabilityClient() {
        return new BitbucketCapabilitiesClientImpl(this.bitbucketRequestExecutor, this.capabilitiesSupplier);
    }

    @Override
    public BitbucketMirrorClient getMirroredRepositoriesClient(int repositoryId) {
        return new BitbucketMirrorClientImpl(this.bitbucketRequestExecutor, repositoryId);
    }

    @Override
    public BitbucketProjectClient getProjectClient(String projectKey) {
        return new BitbucketProjectClientImpl(this.bitbucketRequestExecutor, projectKey);
    }

    @Override
    public BitbucketSearchClient getSearchClient(String projectName) {
        return new BitbucketSearchClientImpl(this.bitbucketRequestExecutor, projectName);
    }
}

