/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.trigger.register;

import com.atlassian.bitbucket.jenkins.internal.client.BitbucketCapabilitiesClient;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketWebhookClient;
import com.atlassian.bitbucket.jenkins.internal.client.exception.BitbucketMissingCapabilityException;
import com.atlassian.bitbucket.jenkins.internal.client.exception.WebhookNotSupportedException;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketWebhook;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketWebhookRequest;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketWebhookSupportedEvents;
import com.atlassian.bitbucket.jenkins.internal.trigger.BitbucketWebhookEvent;
import com.atlassian.bitbucket.jenkins.internal.trigger.register.WebhookHandler;
import com.atlassian.bitbucket.jenkins.internal.trigger.register.WebhookRegisterRequest;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class BitbucketWebhookHandler
implements WebhookHandler {
    private static final String CALLBACK_URL_SUFFIX = "bitbucket-server-webhook/trigger";
    private static final Logger LOGGER = Logger.getLogger(BitbucketWebhookHandler.class.getName());
    private final BitbucketCapabilitiesClient serverCapabilities;
    private final BitbucketWebhookClient webhookClient;

    public BitbucketWebhookHandler(BitbucketCapabilitiesClient serverCapabilities, BitbucketWebhookClient webhookClient) {
        this.serverCapabilities = serverCapabilities;
        this.webhookClient = webhookClient;
    }

    @Override
    public BitbucketWebhook register(WebhookRegisterRequest request) {
        BitbucketWebhookEvent event = this.getEvent(request);
        return this.process(request, event);
    }

    private String constructCallbackUrl(WebhookRegisterRequest request) {
        String jenkinsUrl = request.getJenkinsUrl();
        StringBuilder url = new StringBuilder(request.getJenkinsUrl());
        url = jenkinsUrl.endsWith("/") ? url : url.append("/");
        return url.append(CALLBACK_URL_SUFFIX).toString();
    }

    private BitbucketWebhookRequest createRequest(WebhookRegisterRequest request, BitbucketWebhookEvent event) {
        return BitbucketWebhookRequest.Builder.aRequestFor(event.getEventId(), new String[0]).withCallbackTo(this.constructCallbackUrl(request)).name(request.getName()).build();
    }

    private void deleteWebhooks(List<BitbucketWebhook> webhooks) {
        webhooks.stream().map(BitbucketWebhook::getId).peek(id -> LOGGER.info("Deleting obsolete webhook" + id)).forEach(this.webhookClient::deleteWebhook);
    }

    private Optional<BitbucketWebhook> findSame(List<BitbucketWebhook> webhooks, WebhookRegisterRequest request, BitbucketWebhookEvent toSubscribe) {
        String callback = this.constructCallbackUrl(request);
        return webhooks.stream().filter(hook -> hook.getName().equals(request.getName())).filter(hook -> hook.getUrl().equals(callback)).filter(BitbucketWebhookRequest::isActive).filter(hook -> hook.getEvents().size() == 1).filter(hook -> hook.getEvents().contains(toSubscribe.getEventId())).peek(hook -> LOGGER.info("Found an existing webhook - " + hook)).findFirst();
    }

    private BitbucketWebhookEvent getEvent(WebhookRegisterRequest request) {
        if (request.isMirror()) {
            try {
                BitbucketWebhookSupportedEvents events = this.serverCapabilities.getWebhookSupportedEvents();
                Set<String> hooks = events.getApplicationWebHooks();
                if (hooks.contains(BitbucketWebhookEvent.MIRROR_SYNCHRONIZED_EVENT.getEventId())) {
                    return BitbucketWebhookEvent.MIRROR_SYNCHRONIZED_EVENT;
                }
                if (hooks.contains(BitbucketWebhookEvent.REPO_REF_CHANGE.getEventId())) {
                    return BitbucketWebhookEvent.REPO_REF_CHANGE;
                }
                throw new WebhookNotSupportedException("Remote server does not support the required events.");
            }
            catch (BitbucketMissingCapabilityException exception) {
                return BitbucketWebhookEvent.REPO_REF_CHANGE;
            }
        }
        return BitbucketWebhookEvent.REPO_REF_CHANGE;
    }

    private BitbucketWebhook process(WebhookRegisterRequest request, BitbucketWebhookEvent event) {
        String callback = this.constructCallbackUrl(request);
        List ownedHooks = this.webhookClient.getWebhooks(BitbucketWebhookEvent.REPO_REF_CHANGE.getEventId(), BitbucketWebhookEvent.MIRROR_SYNCHRONIZED_EVENT.getEventId()).filter(hook -> hook.getName().equals(request.getName()) || hook.getUrl().equals(callback)).collect(Collectors.toList());
        List<BitbucketWebhook> webhookWithMirrorSync = ownedHooks.stream().filter(hook -> hook.getEvents().contains(BitbucketWebhookEvent.MIRROR_SYNCHRONIZED_EVENT.getEventId())).collect(Collectors.toList());
        List<BitbucketWebhook> webhookWithRepoRefChange = ownedHooks.stream().filter(hook -> hook.getEvents().contains(BitbucketWebhookEvent.REPO_REF_CHANGE.getEventId())).collect(Collectors.toList());
        if (ownedHooks.size() == 0 || webhookWithMirrorSync.size() == 0 && event == BitbucketWebhookEvent.MIRROR_SYNCHRONIZED_EVENT || webhookWithRepoRefChange.size() == 0 && event == BitbucketWebhookEvent.REPO_REF_CHANGE) {
            BitbucketWebhookRequest webhook = this.createRequest(request, event);
            BitbucketWebhook result = this.webhookClient.registerWebhook(webhook);
            LOGGER.info("New Webhook registered - " + result);
            return result;
        }
        BitbucketWebhook mirrorSyncResult = this.handleExistingWebhook(request, webhookWithMirrorSync, BitbucketWebhookEvent.MIRROR_SYNCHRONIZED_EVENT);
        BitbucketWebhook repoRefResult = this.handleExistingWebhook(request, webhookWithRepoRefChange, BitbucketWebhookEvent.REPO_REF_CHANGE);
        if (mirrorSyncResult != null && mirrorSyncResult.getEvents().contains(event.getEventId())) {
            return mirrorSyncResult;
        }
        return repoRefResult;
    }

    @Nullable
    private BitbucketWebhook handleExistingWebhook(WebhookRegisterRequest request, List<BitbucketWebhook> existingWebhooks, BitbucketWebhookEvent toSubscribe) {
        BitbucketWebhook result = null;
        if (existingWebhooks.size() > 0) {
            result = this.update(existingWebhooks, request, toSubscribe);
            existingWebhooks.remove(result);
            this.deleteWebhooks(existingWebhooks);
        }
        return result;
    }

    private BitbucketWebhook update(List<BitbucketWebhook> webhooks, WebhookRegisterRequest request, BitbucketWebhookEvent toSubscribe) {
        return this.findSame(webhooks, request, toSubscribe).orElseGet(() -> this.updateRemoteWebhook((BitbucketWebhook)webhooks.get(0), request, toSubscribe));
    }

    private BitbucketWebhook updateRemoteWebhook(BitbucketWebhook existing, WebhookRegisterRequest request, BitbucketWebhookEvent toSubscribe) {
        BitbucketWebhookRequest r = this.createRequest(request, toSubscribe);
        BitbucketWebhook updated = this.webhookClient.updateWebhook(existing.getId(), r);
        LOGGER.info(String.format("Exising webhook updtated - %s with new webhook %s", existing, r));
        return updated;
    }
}

