/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.trigger;

import com.atlassian.bitbucket.jenkins.internal.client.BitbucketCapabilitiesClient;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketClientFactory;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketClientFactoryProvider;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketWebhookClient;
import com.atlassian.bitbucket.jenkins.internal.client.exception.AuthorizationException;
import com.atlassian.bitbucket.jenkins.internal.credentials.BitbucketCredentials;
import com.atlassian.bitbucket.jenkins.internal.credentials.GlobalCredentialsProvider;
import com.atlassian.bitbucket.jenkins.internal.credentials.JenkinsToBitbucketCredentials;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketWebhook;
import com.atlassian.bitbucket.jenkins.internal.provider.JenkinsProvider;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMRepository;
import com.atlassian.bitbucket.jenkins.internal.trigger.InstanceBasedNameGenerator;
import com.atlassian.bitbucket.jenkins.internal.trigger.register.BitbucketWebhookHandler;
import com.atlassian.bitbucket.jenkins.internal.trigger.register.WebhookRegisterRequest;
import com.atlassian.bitbucket.jenkins.internal.trigger.register.WebhookRegistrationFailed;
import com.cloudbees.plugins.credentials.Credentials;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;

@Singleton
public class RetryingWebhookHandler {
    private final InstanceBasedNameGenerator instanceBasedNameGenerator;
    private final JenkinsToBitbucketCredentials jenkinsToBitbucketCredentials;
    private final JenkinsProvider jenkinsProvider;
    private final BitbucketClientFactoryProvider provider;

    @Inject
    public RetryingWebhookHandler(JenkinsProvider jenkinsProvider, BitbucketClientFactoryProvider provider, InstanceBasedNameGenerator instanceBasedNameGenerator, JenkinsToBitbucketCredentials jenkinsToBitbucketCredentials) {
        this.jenkinsProvider = Objects.requireNonNull(jenkinsProvider);
        this.provider = Objects.requireNonNull(provider);
        this.instanceBasedNameGenerator = Objects.requireNonNull(instanceBasedNameGenerator);
        this.jenkinsToBitbucketCredentials = Objects.requireNonNull(jenkinsToBitbucketCredentials);
    }

    public BitbucketWebhook register(String bitbucketBaseUrl, GlobalCredentialsProvider globalCredentialsProvider, BitbucketSCMRepository repository) {
        if (StringUtils.isBlank((CharSequence)bitbucketBaseUrl)) {
            throw new IllegalArgumentException("Invalid Bitbucket base URL. Input - " + bitbucketBaseUrl);
        }
        String jenkinsUrl = this.jenkinsProvider.get().getRootUrl();
        if (StringUtils.isBlank((CharSequence)jenkinsUrl)) {
            throw new IllegalArgumentException("Invalid Jenkins base url. Actual - " + jenkinsUrl);
        }
        WebhookRegisterRequest request = WebhookRegisterRequest.Builder.aRequest(repository.getProjectKey(), repository.getRepositorySlug()).withJenkinsBaseUrl(jenkinsUrl).isMirror(repository.isMirrorConfigured()).withName(this.instanceBasedNameGenerator.getUniqueName()).build();
        String jobCredentials = repository.getCredentialsId();
        try {
            return this.registerWithRetry(bitbucketBaseUrl, globalCredentialsProvider, jobCredentials, request);
        }
        catch (Exception ex) {
            String message = "Failed to register webhook in bitbucket server with url " + bitbucketBaseUrl;
            throw new WebhookRegistrationFailed(message, ex);
        }
    }

    private BitbucketWebhook registerUsingCredentials(String bitbucketUrl, BitbucketCredentials credentials, WebhookRegisterRequest request) {
        BitbucketClientFactory clientFactory = this.provider.getClient(bitbucketUrl, credentials);
        BitbucketCapabilitiesClient capabilityClient = clientFactory.getCapabilityClient();
        BitbucketWebhookClient webhookClient = clientFactory.getProjectClient(request.getProjectKey()).getRepositoryClient(request.getRepoSlug()).getWebhookClient();
        BitbucketWebhookHandler handler = new BitbucketWebhookHandler(capabilityClient, webhookClient);
        return handler.register(request);
    }

    @Nullable
    private BitbucketWebhook registerUsingCredentialsQuietly(String bitbucketUrl, BitbucketCredentials credentials, WebhookRegisterRequest request) {
        try {
            return this.registerUsingCredentials(bitbucketUrl, credentials, request);
        }
        catch (AuthorizationException exception) {
            return null;
        }
    }

    private BitbucketWebhook registerWithRetry(String bitbucketUrl, GlobalCredentialsProvider globalCredentialsProvider, String jobCredentials, WebhookRegisterRequest request) {
        BitbucketWebhook result = globalCredentialsProvider.getGlobalAdminCredentials().map(c -> this.registerUsingCredentialsQuietly(bitbucketUrl, this.jenkinsToBitbucketCredentials.toBitbucketCredentials((Credentials)c), request)).orElse(null);
        if (result == null) {
            BitbucketCredentials credentials = this.jenkinsToBitbucketCredentials.toBitbucketCredentials(jobCredentials);
            result = this.registerUsingCredentialsQuietly(bitbucketUrl, credentials, request);
        }
        if (result == null) {
            result = globalCredentialsProvider.getGlobalCredentials().map(c -> this.registerUsingCredentials(bitbucketUrl, this.jenkinsToBitbucketCredentials.toBitbucketCredentials((Credentials)c), request)).orElse(null);
        }
        return result;
    }
}

