/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.trigger;

import com.atlassian.bitbucket.jenkins.internal.client.exception.BitbucketClientException;
import com.atlassian.bitbucket.jenkins.internal.config.BitbucketPluginConfiguration;
import com.atlassian.bitbucket.jenkins.internal.config.BitbucketServerConfiguration;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketWebhook;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMRepository;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMSource;
import com.atlassian.bitbucket.jenkins.internal.trigger.Messages;
import com.atlassian.bitbucket.jenkins.internal.trigger.RetryingWebhookHandler;
import com.google.common.annotations.VisibleForTesting;
import hudson.Extension;
import hudson.model.Item;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import jenkins.branch.MultiBranchProject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class BitbucketWebhookMultibranchTrigger
extends Trigger<MultiBranchProject<?, ?>> {
    private static final Logger LOGGER = Logger.getLogger(BitbucketWebhookMultibranchTrigger.class.getName());

    @DataBoundConstructor
    public BitbucketWebhookMultibranchTrigger() {
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Symbol(value={"BitbucketWebhookMultibranchTriggerImpl"})
    @Extension
    public static class DescriptorImpl
    extends TriggerDescriptor {
        @Inject
        private BitbucketPluginConfiguration bitbucketPluginConfiguration;
        @Inject
        private RetryingWebhookHandler retryingWebhookHandler;

        public DescriptorImpl() {
        }

        @VisibleForTesting
        DescriptorImpl(RetryingWebhookHandler webhookHandler, BitbucketPluginConfiguration bitbucketPluginConfiguration) {
            this.retryingWebhookHandler = webhookHandler;
            this.bitbucketPluginConfiguration = bitbucketPluginConfiguration;
        }

        public String getDisplayName() {
            return Messages.BitbucketWebhookMultibranchTrigger_displayname();
        }

        public boolean isApplicable(Item item) {
            return item instanceof MultiBranchProject;
        }

        public boolean addTrigger(Item item, BitbucketSCMSource scm) {
            try {
                this.registerWebhook(item, scm.getBitbucketSCMRepository());
                return true;
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "There was a problem while trying to add webhook", ex);
                throw ex;
            }
        }

        private BitbucketServerConfiguration getServer(String serverId) {
            return this.bitbucketPluginConfiguration.getServerById(serverId).orElseThrow(() -> new BitbucketClientException("Server config not found for input server id " + serverId));
        }

        private void registerWebhook(Item item, BitbucketSCMRepository repository) {
            Objects.requireNonNull(repository.getServerId());
            BitbucketServerConfiguration bitbucketServerConfiguration = this.getServer(repository.getServerId());
            BitbucketWebhook webhook = this.retryingWebhookHandler.register(bitbucketServerConfiguration.getBaseUrl(), bitbucketServerConfiguration.getGlobalCredentialsProvider(item), repository);
            LOGGER.info("Webhook returned - " + webhook);
        }
    }
}

